/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util.prefs;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jhotdraw.util.prefs.ToolBarPrefsHandler;

public class PreferencesUtil
extends Preferences {
    private HashMap<String, Object> map = new HashMap();
    private boolean isUserNode;
    private static HashMap<Package, Preferences> systemNodes;
    private static HashMap<Package, Preferences> userNodes;

    public PreferencesUtil(boolean isUserNode) {
        this.isUserNode = isUserNode;
    }

    @Override
    public void put(String key, String value) {
        this.map.put(key, value);
    }

    @Override
    public String get(String key, String def) {
        return this.map.containsKey(key) ? this.map.get(key) : def;
    }

    @Override
    public void remove(String key) {
        this.map.remove(key);
    }

    @Override
    public void clear() throws BackingStoreException {
        this.map.clear();
    }

    @Override
    public void putInt(String key, int value) {
        this.map.put(key, value);
    }

    @Override
    public int getInt(String key, int def) {
        return (Integer)(this.map.containsKey(key) ? this.map.get(key) : Integer.valueOf(def));
    }

    @Override
    public void putLong(String key, long value) {
        this.map.put(key, value);
    }

    @Override
    public long getLong(String key, long def) {
        return (Long)(this.map.containsKey(key) ? this.map.get(key) : Long.valueOf(def));
    }

    @Override
    public void putBoolean(String key, boolean value) {
        this.map.put(key, value);
    }

    @Override
    public boolean getBoolean(String key, boolean def) {
        return (Boolean)(this.map.containsKey(key) ? this.map.get(key) : Boolean.valueOf(def));
    }

    @Override
    public void putFloat(String key, float value) {
        this.map.put(key, Float.valueOf(value));
    }

    @Override
    public float getFloat(String key, float def) {
        return ((Float)(this.map.containsKey(key) ? this.map.get(key) : Float.valueOf(def))).floatValue();
    }

    @Override
    public void putDouble(String key, double value) {
        this.map.put(key, value);
    }

    @Override
    public double getDouble(String key, double def) {
        return (Double)(this.map.containsKey(key) ? this.map.get(key) : Double.valueOf(def));
    }

    @Override
    public void putByteArray(String key, byte[] value) {
        this.map.put(key, value);
    }

    @Override
    public byte[] getByteArray(String key, byte[] def) {
        return this.map.containsKey(key) ? (Object)this.map.get(key) : def;
    }

    @Override
    public String[] keys() throws BackingStoreException {
        return this.map.keySet().toArray(new String[this.map.keySet().size()]);
    }

    @Override
    public String[] childrenNames() throws BackingStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Preferences parent() {
        return null;
    }

    @Override
    public Preferences node(String pathName) {
        return null;
    }

    @Override
    public boolean nodeExists(String pathName) throws BackingStoreException {
        return false;
    }

    @Override
    public void removeNode() throws BackingStoreException {
    }

    @Override
    public String name() {
        return "Dummy";
    }

    @Override
    public String absolutePath() {
        return "Dummy";
    }

    @Override
    public boolean isUserNode() {
        return this.isUserNode;
    }

    @Override
    public String toString() {
        return "Dummy";
    }

    @Override
    public void flush() throws BackingStoreException {
        this.clear();
    }

    @Override
    public void sync() throws BackingStoreException {
    }

    @Override
    public void addPreferenceChangeListener(PreferenceChangeListener pcl) {
    }

    @Override
    public void removePreferenceChangeListener(PreferenceChangeListener pcl) {
    }

    @Override
    public void addNodeChangeListener(NodeChangeListener ncl) {
    }

    @Override
    public void removeNodeChangeListener(NodeChangeListener ncl) {
    }

    @Override
    public void exportNode(OutputStream os) throws IOException, BackingStoreException {
    }

    @Override
    public void exportSubtree(OutputStream os) throws IOException, BackingStoreException {
    }

    public static Preferences systemNodeForPackage(Class<?> c) {
        if (systemNodes != null) {
            if (!systemNodes.containsKey(c.getPackage())) {
                systemNodes.put(c.getPackage(), new PreferencesUtil(false));
            }
            return systemNodes.get(c.getPackage());
        }
        try {
            return Preferences.systemNodeForPackage(c);
        }
        catch (Throwable t) {
            if (systemNodes == null) {
                systemNodes = new HashMap();
            }
            return PreferencesUtil.systemNodeForPackage(c);
        }
    }

    public static Preferences userNodeForPackage(Class<?> c) {
        if (userNodes != null) {
            if (!userNodes.containsKey(c.getPackage())) {
                userNodes.put(c.getPackage(), new PreferencesUtil(false));
            }
            return userNodes.get(c.getPackage());
        }
        try {
            return Preferences.userNodeForPackage(c);
        }
        catch (Throwable t) {
            if (userNodes == null) {
                userNodes = new HashMap();
            }
            return PreferencesUtil.userNodeForPackage(c);
        }
    }

    public static void installPrefsHandler(Preferences prefs, String string, JTabbedPane tabbedPane) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private PreferencesUtil() {
    }

    public static void installFramePrefsHandler(Preferences prefs, String name, Window window) {
        PreferencesUtil.installFramePrefsHandler(prefs, name, window, new Dimension(400, 300));
    }

    public static void installFramePrefsHandler(final Preferences prefs, final String name, Window window, Dimension defaultSize) {
        GraphicsConfiguration conf = window.getGraphicsConfiguration();
        Rectangle screenBounds = conf.getBounds();
        Insets screenInsets = window.getToolkit().getScreenInsets(conf);
        screenBounds.x += screenInsets.left;
        screenBounds.y += screenInsets.top;
        screenBounds.width -= screenInsets.left + screenInsets.right;
        screenBounds.height -= screenInsets.top + screenInsets.bottom;
        window.pack();
        Dimension preferredSize = window.getPreferredSize();
        boolean resizable = true;
        if (window instanceof Frame) {
            resizable = ((Frame)window).isResizable();
        } else if (window instanceof Dialog) {
            resizable = ((Dialog)window).isResizable();
        }
        Rectangle bounds = resizable ? new Rectangle(prefs.getInt(name + ".x", 0), prefs.getInt(name + ".y", 0), Math.max(defaultSize.width, prefs.getInt(name + ".width", preferredSize.width)), Math.max(defaultSize.height, prefs.getInt(name + ".height", preferredSize.height))) : new Rectangle(prefs.getInt(name + ".x", 0), prefs.getInt(name + ".y", 0), window.getWidth(), window.getHeight());
        if (!screenBounds.contains(bounds)) {
            bounds.x = screenBounds.x + (screenBounds.width - bounds.width) / 2;
            bounds.y = screenBounds.y + (screenBounds.height - bounds.height) / 3;
            Rectangle.intersect(screenBounds, bounds, bounds);
        }
        window.setBounds(bounds);
        window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                prefs.putInt(name + ".x", evt.getComponent().getX());
                prefs.putInt(name + ".y", evt.getComponent().getY());
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                prefs.putInt(name + ".width", evt.getComponent().getWidth());
                prefs.putInt(name + ".height", evt.getComponent().getHeight());
            }
        });
    }

    public static void installPalettePrefsHandler(Preferences prefs, String name, Window window) {
        PreferencesUtil.installPalettePrefsHandler(prefs, name, window, 0);
    }

    public static void installPalettePrefsHandler(final Preferences prefs, final String name, Window window, int x) {
        GraphicsConfiguration conf = window.getGraphicsConfiguration();
        Rectangle screenBounds = conf.getBounds();
        Insets screenInsets = window.getToolkit().getScreenInsets(conf);
        screenBounds.x += screenInsets.left;
        screenBounds.y += screenInsets.top;
        screenBounds.width -= screenInsets.left + screenInsets.right;
        screenBounds.height -= screenInsets.top + screenInsets.bottom;
        Dimension preferredSize = window.getPreferredSize();
        Rectangle bounds = new Rectangle(prefs.getInt(name + ".x", x + screenBounds.x), prefs.getInt(name + ".y", 0 + screenBounds.y), preferredSize.width, preferredSize.height);
        if (!screenBounds.contains(bounds)) {
            bounds.x = screenBounds.x;
            bounds.y = screenBounds.y;
        }
        window.setBounds(bounds);
        window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                prefs.putInt(name + ".x", evt.getComponent().getX());
                prefs.putInt(name + ".y", evt.getComponent().getY());
            }
        });
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                prefs.putBoolean(name + ".visible", false);
            }

            @Override
            public void windowOpened(WindowEvent e) {
                prefs.putBoolean(name + ".visible", true);
            }
        });
    }

    public static void installInternalFramePrefsHandler(final Preferences prefs, final String name, JInternalFrame window, JDesktopPane desktop) {
        Rectangle screenBounds = desktop.getBounds();
        screenBounds.setLocation(0, 0);
        Insets screenInsets = desktop.getInsets();
        screenBounds.x += screenInsets.left;
        screenBounds.y += screenInsets.top;
        screenBounds.width -= screenInsets.left + screenInsets.right;
        screenBounds.height -= screenInsets.top + screenInsets.bottom;
        Dimension preferredSize = window.getPreferredSize();
        Dimension minSize = window.getMinimumSize();
        Rectangle bounds = new Rectangle(prefs.getInt(name + ".x", 0), prefs.getInt(name + ".y", 0), Math.max(minSize.width, prefs.getInt(name + ".width", preferredSize.width)), Math.max(minSize.height, prefs.getInt(name + ".height", preferredSize.height)));
        if (!screenBounds.contains(bounds)) {
            bounds.x = screenBounds.x + (screenBounds.width - bounds.width) / 2;
            bounds.y = screenBounds.y + (screenBounds.height - bounds.height) / 2;
            Rectangle.intersect(screenBounds, bounds, bounds);
        }
        window.setBounds(bounds);
        window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                prefs.putInt(name + ".x", evt.getComponent().getX());
                prefs.putInt(name + ".y", evt.getComponent().getY());
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                prefs.putInt(name + ".width", evt.getComponent().getWidth());
                prefs.putInt(name + ".height", evt.getComponent().getHeight());
            }
        });
    }

    public static void installToolBarPrefsHandler(Preferences prefs, String name, JToolBar toolbar) {
        new ToolBarPrefsHandler(toolbar, name, prefs);
    }

    public static void installTabbedPanePrefsHandler(final Preferences prefs, final String name, final JTabbedPane tabbedPane) {
        int selectedTab = prefs.getInt(name, 0);
        try {
            tabbedPane.setSelectedIndex(selectedTab);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                prefs.putInt(name, tabbedPane.getSelectedIndex());
            }
        });
    }
}

