/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.beans.PropertyChangeEdit;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.event.CompositeFigureEdit;
import org.jhotdraw.draw.handle.AbstractHandle;
import org.jhotdraw.draw.handle.HandleAttributeKeys;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.SVGRectFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class SVGRectRadiusHandle
extends AbstractHandle {
    private static final boolean DEBUG = false;
    private static final int OFFSET = 6;
    private Dimension2DDouble originalArc2D;

    public SVGRectRadiusHandle(Figure owner) {
        super(owner);
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.getEditor().getTool().supportsHandleInteraction()) {
            this.drawDiamond(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_STROKE_COLOR));
        } else {
            this.drawDiamond(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_FILL_COLOR_DISABLED), this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_STROKE_COLOR_DISABLED));
        }
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle r = new Rectangle(this.locate());
        r.grow(this.getHandlesize() / 2 + 1, this.getHandlesize() / 2 + 1);
        return r;
    }

    private Point locate() {
        SVGRectFigure owner = (SVGRectFigure)this.getOwner();
        Rectangle2D.Double r = owner.getBounds();
        Point2D.Double p = new Point2D.Double(r.x + owner.getArcWidth(), r.y + owner.getArcHeight());
        if (owner.get(SVGAttributeKeys.TRANSFORM) != null) {
            ((AffineTransform)owner.get(SVGAttributeKeys.TRANSFORM)).transform(p, p);
        }
        return this.view.drawingToView(p);
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
        SVGRectFigure svgRect = (SVGRectFigure)this.getOwner();
        this.originalArc2D = new Dimension2DDouble(svgRect.getArcWidth(), svgRect.getArcHeight());
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        SVGRectFigure owner = (SVGRectFigure)this.getOwner();
        owner.willChange();
        Point2D.Double p = this.view.viewToDrawing(lead);
        if (owner.get(SVGAttributeKeys.TRANSFORM) != null) {
            try {
                ((AffineTransform)owner.get(SVGAttributeKeys.TRANSFORM)).inverseTransform(p, p);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        Rectangle2D.Double r = owner.getBounds();
        owner.setArc(Math.min(owner.getWidth(), Math.max(0.0, p.x - r.x)), Math.min(owner.getHeight(), Math.max(0.0, p.y - r.y)));
        owner.changed();
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        SVGRectFigure svgRect = (SVGRectFigure)this.getOwner();
        Dimension2DDouble oldValue = this.originalArc2D;
        Dimension2DDouble newValue = new Dimension2DDouble(svgRect.getArcWidth(), svgRect.getArcHeight());
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        CompositeFigureEdit edit = new CompositeFigureEdit((Figure)svgRect, labels.getString("attribute.roundRectRadius"));
        edit.setVerbose(true);
        this.fireUndoableEditHappened(edit);
        this.fireUndoableEditHappened(new PropertyChangeEdit((Object)svgRect, "arcWidth", oldValue.width, newValue.width));
        this.fireUndoableEditHappened(new PropertyChangeEdit((Object)svgRect, "arcHeight", oldValue.height, newValue.height));
        this.fireUndoableEditHappened(edit);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        SVGRectFigure owner = (SVGRectFigure)this.getOwner();
        Dimension2DDouble oldArc = new Dimension2DDouble(owner.getArcWidth(), owner.getArcHeight());
        Dimension2DDouble newArc = new Dimension2DDouble(owner.getArcWidth(), owner.getArcHeight());
        switch (evt.getKeyCode()) {
            case 38: {
                if (newArc.height > 0.0) {
                    newArc.height = Math.max(0.0, newArc.height - 1.0);
                }
                evt.consume();
                break;
            }
            case 40: {
                newArc.height = Math.min(owner.getHeight(), newArc.height + 1.0);
                evt.consume();
                break;
            }
            case 37: {
                if (newArc.width > 0.0) {
                    newArc.width = Math.max(0.0, newArc.width - 1.0);
                }
                evt.consume();
                break;
            }
            case 39: {
                newArc.width = Math.min(owner.getWidth(), newArc.width + 1.0);
                evt.consume();
            }
        }
        if (!newArc.equals(oldArc)) {
            owner.willChange();
            owner.setArc(newArc.width, newArc.height);
            owner.changed();
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            CompositeFigureEdit edit = new CompositeFigureEdit((Figure)owner, labels.getString("attribute.roundRectRadius"));
            this.fireUndoableEditHappened(edit);
            this.fireUndoableEditHappened(new PropertyChangeEdit((Object)owner, "arcWidth", oldArc.width, newArc.width));
            this.fireUndoableEditHappened(new PropertyChangeEdit((Object)owner, "arcHeight", oldArc.height, newArc.height));
            this.fireUndoableEditHappened(edit);
        }
    }

    @Override
    public String getToolTipText(Point p) {
        return ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels").getString("handle.roundRectangleRadius.toolTipText");
    }
}

