/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jhotdraw.draw.ImageHolderFigure;
import org.jhotdraw.draw.event.TransformRestoreEdit;
import org.jhotdraw.draw.handle.BoundsOutlineHandle;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.ResizeHandleKit;
import org.jhotdraw.draw.handle.TransformHandleKit;
import org.jhotdraw.geom.GrowStroke;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.LinkHandle;
import org.jhotdraw.samples.svg.figures.SVGAttributedFigure;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class SVGImageFigure
extends SVGAttributedFigure
implements SVGFigure,
ImageHolderFigure {
    private Rectangle2D.Double rectangle;
    @Nullable
    private transient Shape cachedTransformedShape;
    @Nullable
    private transient Shape cachedHitShape;
    @Nullable
    private byte[] imageData;
    @Nullable
    private BufferedImage bufferedImage;

    public SVGImageFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public SVGImageFigure(double x, double y, double width, double height) {
        this.rectangle = new Rectangle2D.Double(x, y, width, height);
        SVGAttributeKeys.setDefaults(this);
        this.setConnectable(false);
    }

    @Override
    public void draw(Graphics2D g) {
        double opacity = this.get(SVGAttributeKeys.OPACITY);
        if ((opacity = Math.min(Math.max(0.0, opacity), 1.0)) != 0.0) {
            BufferedImage image;
            Composite savedComposite = g.getComposite();
            if (opacity != 1.0) {
                g.setComposite(AlphaComposite.getInstance(3, (float)opacity));
            }
            if ((image = this.getBufferedImage()) != null) {
                if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
                    Graphics2D gx = (Graphics2D)g.create();
                    gx.setRenderingHints(g.getRenderingHints());
                    gx.transform((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM));
                    gx.drawImage(image, (int)this.rectangle.x, (int)this.rectangle.y, (int)this.rectangle.width, (int)this.rectangle.height, null);
                    gx.dispose();
                } else {
                    g.drawImage(image, (int)this.rectangle.x, (int)this.rectangle.y, (int)this.rectangle.width, (int)this.rectangle.height, null);
                }
            } else {
                Shape shape = this.getTransformedShape();
                g.setColor(Color.red);
                g.setStroke(new BasicStroke());
                g.draw(shape);
            }
            if (opacity != 1.0) {
                g.setComposite(savedComposite);
            }
        }
    }

    @Override
    protected void drawFill(Graphics2D g) {
    }

    @Override
    protected void drawStroke(Graphics2D g) {
    }

    public double getX() {
        return this.rectangle.x;
    }

    public double getY() {
        return this.rectangle.y;
    }

    public double getWidth() {
        return this.rectangle.width;
    }

    public double getHeight() {
        return this.rectangle.height;
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.rectangle.clone();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D rx = this.getTransformedShape().getBounds2D();
        Rectangle2D.Double r = rx instanceof Rectangle2D.Double ? (Rectangle2D.Double)rx : new Rectangle2D.Double(rx.getX(), rx.getY(), rx.getWidth(), rx.getHeight());
        return r;
    }

    @Override
    public boolean contains(Point2D.Double p) {
        return this.getHitShape().contains(p);
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.invalidateTransformedShape();
        this.rectangle.x = Math.min(anchor.x, lead.x);
        this.rectangle.y = Math.min(anchor.y, lead.y);
        this.rectangle.width = Math.max(0.1, Math.abs(lead.x - anchor.x));
        this.rectangle.height = Math.max(0.1, Math.abs(lead.y - anchor.y));
    }

    private void invalidateTransformedShape() {
        this.cachedTransformedShape = null;
        this.cachedHitShape = null;
    }

    private Shape getTransformedShape() {
        if (this.cachedTransformedShape == null) {
            this.cachedTransformedShape = (Shape)this.rectangle.clone();
            if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
                this.cachedTransformedShape = ((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).createTransformedShape(this.cachedTransformedShape);
            }
        }
        return this.cachedTransformedShape;
    }

    private Shape getHitShape() {
        if (this.cachedHitShape == null) {
            this.cachedHitShape = new GrowStroke((float)SVGAttributeKeys.getStrokeTotalWidth(this) / 2.0f, (float)SVGAttributeKeys.getStrokeTotalMiterLimit(this)).createStrokedShape(this.getTransformedShape());
        }
        return this.cachedHitShape;
    }

    @Override
    public void transform(AffineTransform tx) {
        this.invalidateTransformedShape();
        if (this.get(SVGAttributeKeys.TRANSFORM) != null || (tx.getType() & 7) != tx.getType()) {
            if (this.get(SVGAttributeKeys.TRANSFORM) == null) {
                this.set(SVGAttributeKeys.TRANSFORM, (AffineTransform)tx.clone());
            } else {
                AffineTransform t = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(this);
                t.preConcatenate(tx);
                this.set(SVGAttributeKeys.TRANSFORM, t);
            }
        } else {
            Point2D.Double anchor = this.getStartPoint();
            Point2D.Double lead = this.getEndPoint();
            this.setBounds((Point2D.Double)tx.transform(anchor, anchor), (Point2D.Double)tx.transform(lead, lead));
        }
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        this.invalidateTransformedShape();
        Object[] o = (Object[])geometry;
        this.rectangle = (Rectangle2D.Double)((Rectangle2D.Double)o[0]).clone();
        if (o[1] == null) {
            this.set(SVGAttributeKeys.TRANSFORM, null);
        } else {
            this.set(SVGAttributeKeys.TRANSFORM, (AffineTransform)((AffineTransform)o[1]).clone());
        }
    }

    @Override
    public Object getTransformRestoreData() {
        return new Object[]{this.rectangle.clone(), this.get(SVGAttributeKeys.TRANSFORM)};
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel % 2) {
            case -1: {
                handles.add(new BoundsOutlineHandle(this, false, true));
                break;
            }
            case 0: {
                ResizeHandleKit.addResizeHandles(this, handles);
                handles.add(new LinkHandle(this));
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, handles);
                break;
            }
        }
        return handles;
    }

    @Override
    public Collection<Action> getActions(Point2D.Double p) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        LinkedList<Action> actions = new LinkedList<Action>();
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            actions.add(new AbstractAction(labels.getString("edit.removeTransform.text")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SVGImageFigure.this.willChange();
                    SVGImageFigure.this.fireUndoableEditHappened(SVGAttributeKeys.TRANSFORM.setUndoable(SVGImageFigure.this, null));
                    SVGImageFigure.this.changed();
                }
            });
        }
        if (this.bufferedImage != null) {
            double figureRatio;
            double imageRatio;
            if (this.rectangle.width != (double)this.bufferedImage.getWidth() || this.rectangle.height != (double)this.bufferedImage.getHeight()) {
                actions.add(new AbstractAction(labels.getString("edit.setToImageSize.text")){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        Object geometry = SVGImageFigure.this.getTransformRestoreData();
                        SVGImageFigure.this.willChange();
                        SVGImageFigure.this.rectangle = new Rectangle2D.Double(((SVGImageFigure)SVGImageFigure.this).rectangle.x - ((double)SVGImageFigure.this.bufferedImage.getWidth() - ((SVGImageFigure)SVGImageFigure.this).rectangle.width) / 2.0, ((SVGImageFigure)SVGImageFigure.this).rectangle.y - ((double)SVGImageFigure.this.bufferedImage.getHeight() - ((SVGImageFigure)SVGImageFigure.this).rectangle.height) / 2.0, SVGImageFigure.this.bufferedImage.getWidth(), SVGImageFigure.this.bufferedImage.getHeight());
                        SVGImageFigure.this.fireUndoableEditHappened(new TransformRestoreEdit(SVGImageFigure.this, geometry, SVGImageFigure.this.getTransformRestoreData()));
                        SVGImageFigure.this.changed();
                    }
                });
            }
            if (Math.abs((imageRatio = (double)this.bufferedImage.getHeight() / (double)this.bufferedImage.getWidth()) - (figureRatio = this.rectangle.height / this.rectangle.width)) > 0.001) {
                actions.add(new AbstractAction(labels.getString("edit.adjustHeightToImageAspect.text")){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        Object geometry = SVGImageFigure.this.getTransformRestoreData();
                        SVGImageFigure.this.willChange();
                        double newHeight = (double)SVGImageFigure.this.bufferedImage.getHeight() * ((SVGImageFigure)SVGImageFigure.this).rectangle.width / (double)SVGImageFigure.this.bufferedImage.getWidth();
                        SVGImageFigure.this.rectangle = new Rectangle2D.Double(((SVGImageFigure)SVGImageFigure.this).rectangle.x, ((SVGImageFigure)SVGImageFigure.this).rectangle.y - (newHeight - ((SVGImageFigure)SVGImageFigure.this).rectangle.height) / 2.0, ((SVGImageFigure)SVGImageFigure.this).rectangle.width, newHeight);
                        SVGImageFigure.this.fireUndoableEditHappened(new TransformRestoreEdit(SVGImageFigure.this, geometry, SVGImageFigure.this.getTransformRestoreData()));
                        SVGImageFigure.this.changed();
                    }
                });
                actions.add(new AbstractAction(labels.getString("edit.adjustWidthToImageAspect.text")){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        Object geometry = SVGImageFigure.this.getTransformRestoreData();
                        SVGImageFigure.this.willChange();
                        double newWidth = (double)SVGImageFigure.this.bufferedImage.getWidth() * ((SVGImageFigure)SVGImageFigure.this).rectangle.height / (double)SVGImageFigure.this.bufferedImage.getHeight();
                        SVGImageFigure.this.rectangle = new Rectangle2D.Double(((SVGImageFigure)SVGImageFigure.this).rectangle.x - (newWidth - ((SVGImageFigure)SVGImageFigure.this).rectangle.width) / 2.0, ((SVGImageFigure)SVGImageFigure.this).rectangle.y, newWidth, ((SVGImageFigure)SVGImageFigure.this).rectangle.height);
                        SVGImageFigure.this.fireUndoableEditHappened(new TransformRestoreEdit(SVGImageFigure.this, geometry, SVGImageFigure.this.getTransformRestoreData()));
                        SVGImageFigure.this.changed();
                    }
                });
            }
        }
        return actions;
    }

    @Override
    public SVGImageFigure clone() {
        SVGImageFigure that = (SVGImageFigure)super.clone();
        that.rectangle = (Rectangle2D.Double)this.rectangle.clone();
        that.cachedTransformedShape = null;
        that.cachedHitShape = null;
        return that;
    }

    @Override
    public boolean isEmpty() {
        Rectangle2D.Double b = this.getBounds();
        return b.width <= 0.0 || b.height <= 0.0 || this.imageData == null && this.bufferedImage == null;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.invalidateTransformedShape();
    }

    @Override
    public void setImage(byte[] imageData, BufferedImage bufferedImage) {
        this.willChange();
        this.imageData = imageData;
        this.bufferedImage = bufferedImage;
        this.changed();
    }

    public void setImageData(byte[] imageData) {
        this.willChange();
        this.imageData = imageData;
        this.bufferedImage = null;
        this.changed();
    }

    @Override
    public void setBufferedImage(BufferedImage image) {
        this.willChange();
        this.imageData = null;
        this.bufferedImage = image;
        this.changed();
    }

    @Override
    @Nullable
    public BufferedImage getBufferedImage() {
        if (this.bufferedImage == null && this.imageData != null) {
            try {
                this.bufferedImage = ImageIO.read(new ByteArrayInputStream(this.imageData));
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.imageData = null;
            }
        }
        return this.bufferedImage;
    }

    @Override
    @Nullable
    public byte[] getImageData() {
        if (this.bufferedImage != null && this.imageData == null) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)this.bufferedImage, "PNG", bout);
                bout.close();
                this.imageData = bout.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.bufferedImage = null;
            }
        }
        return this.imageData;
    }

    @Override
    public void loadImage(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            this.loadImage(in);
        }
    }

    @Override
    public void loadImage(InputStream in) throws IOException {
        BufferedImage img;
        int bytesRead;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        while ((bytesRead = in.read(buf)) > 0) {
            baos.write(buf, 0, bytesRead);
        }
        try {
            img = ImageIO.read(new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (Throwable t) {
            img = null;
        }
        if (img == null) {
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            throw new IOException(labels.getFormatted("file.failedToLoadImage.message", in.toString()));
        }
        this.imageData = baos.toByteArray();
        this.bufferedImage = img;
    }
}

