/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.DefaultApplicationModel;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractViewAction;
import org.jhotdraw.app.action.edit.CopyAction;
import org.jhotdraw.app.action.edit.CutAction;
import org.jhotdraw.app.action.edit.DuplicateAction;
import org.jhotdraw.app.action.edit.PasteAction;
import org.jhotdraw.app.action.edit.SelectAllAction;
import org.jhotdraw.app.action.file.ExportFileAction;
import org.jhotdraw.app.action.view.ToggleViewPropertyAction;
import org.jhotdraw.app.action.view.ViewPropertyAction;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.ApplyAttributesAction;
import org.jhotdraw.draw.action.BringToFrontAction;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.PickAttributesAction;
import org.jhotdraw.draw.action.SelectSameAction;
import org.jhotdraw.draw.action.SendToBackAction;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.draw.io.InputFormat;
import org.jhotdraw.draw.io.OutputFormat;
import org.jhotdraw.draw.tool.CreationTool;
import org.jhotdraw.gui.JFileURIChooser;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.samples.odg.ODGAttributeKeys;
import org.jhotdraw.samples.odg.ODGView;
import org.jhotdraw.samples.odg.action.CombineAction;
import org.jhotdraw.samples.odg.action.SplitAction;
import org.jhotdraw.samples.odg.figures.ODGGroupFigure;
import org.jhotdraw.samples.odg.figures.ODGPathFigure;
import org.jhotdraw.samples.odg.figures.ODGRectFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class ODGApplicationModel
extends DefaultApplicationModel {
    private static final double[] scaleFactors = new double[]{5.0, 4.0, 3.0, 2.0, 1.5, 1.25, 1.0, 0.75, 0.5, 0.25, 0.1};
    private DefaultDrawingEditor sharedEditor;

    public ODGApplicationModel() {
        this.setViewClass(ODGView.class);
    }

    public DefaultDrawingEditor getSharedEditor() {
        if (this.sharedEditor == null) {
            this.sharedEditor = new DefaultDrawingEditor();
        }
        return this.sharedEditor;
    }

    public static Collection<Action> createDrawingActions(DrawingEditor editor) {
        LinkedList<Action> a = new LinkedList<Action>();
        a.add(new CutAction());
        a.add(new CopyAction());
        a.add(new PasteAction());
        a.add(new SelectAllAction());
        a.add(new SelectSameAction(editor));
        return a;
    }

    public static Collection<Action> createSelectionActions(DrawingEditor editor) {
        LinkedList<Action> a = new LinkedList<Action>();
        a.add(new DuplicateAction());
        a.add(null);
        a.add(new GroupAction(editor, new ODGGroupFigure()));
        a.add(new UngroupAction(editor, new ODGGroupFigure()));
        a.add(new CombineAction(editor));
        a.add(new SplitAction(editor));
        a.add(null);
        a.add(new BringToFrontAction(editor));
        a.add(new SendToBackAction(editor));
        return a;
    }

    private void addCreationButtonsTo(JToolBar tb, DrawingEditor editor) {
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        ButtonFactory.addSelectionToolTo(tb, editor, ODGApplicationModel.createDrawingActions(editor), ODGApplicationModel.createSelectionActions(editor));
        tb.addSeparator();
        HashMap<AttributeKey<Object>, Object> attributes = new HashMap<AttributeKey, Object>();
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new ODGRectFigure(), attributes), "edit.createRectangle", drawLabels);
        attributes = new HashMap();
        attributes.put(AttributeKeys.FILL_COLOR, null);
        attributes.put(AttributeKeys.STROKE_COLOR, Color.black);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new ODGPathFigure(), attributes), "edit.createLine", drawLabels);
        attributes = new HashMap();
        attributes.put(AttributeKeys.FILL_COLOR, Color.black);
        attributes.put(AttributeKeys.STROKE_COLOR, null);
        attributes = new HashMap();
        attributes.put(AttributeKeys.FILL_COLOR, null);
        attributes.put(AttributeKeys.STROKE_COLOR, null);
    }

    private void addAttributesButtonsTo(JToolBar bar, DrawingEditor editor) {
        JButton b = bar.add(new PickAttributesAction(editor));
        b.setFocusable(false);
        b = bar.add(new ApplyAttributesAction(editor));
        b.setFocusable(false);
        bar.addSeparator();
        this.addColorButtonsTo(bar, editor);
        bar.addSeparator();
        this.addStrokeButtonsTo(bar, editor);
        bar.addSeparator();
        ButtonFactory.addFontButtonsTo(bar, editor);
    }

    private void addColorButtonsTo(JToolBar bar, DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        HashMap<AttributeKey<Object>, Object> defaultAttributes = new HashMap<AttributeKey, Object>();
        ODGAttributeKeys.STROKE_GRADIENT.put(defaultAttributes, null);
        bar.add(ButtonFactory.createEditorColorButton(editor, ODGAttributeKeys.STROKE_COLOR, ButtonFactory.WEBSAVE_COLORS, 19, "attribute.strokeColor", labels, defaultAttributes));
        defaultAttributes = new HashMap();
        ODGAttributeKeys.FILL_GRADIENT.put(defaultAttributes, null);
        bar.add(ButtonFactory.createEditorColorButton(editor, ODGAttributeKeys.FILL_COLOR, ButtonFactory.WEBSAVE_COLORS, 19, "attribute.fillColor", labels, defaultAttributes));
    }

    private void addStrokeButtonsTo(JToolBar bar, DrawingEditor editor) {
        bar.add(ButtonFactory.createStrokeWidthButton(editor));
        bar.add(ButtonFactory.createStrokeDashesButton(editor));
        bar.add(ButtonFactory.createStrokeCapButton(editor));
        bar.add(ButtonFactory.createStrokeJoinButton(editor));
    }

    @Override
    public List<JToolBar> createToolBars(Application a, @Nullable View pr) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        ODGView p = (ODGView)pr;
        DrawingEditor editor = p == null ? this.getSharedEditor() : p.getEditor();
        LinkedList<JToolBar> list = new LinkedList<JToolBar>();
        JToolBar tb = new JToolBar();
        this.addCreationButtonsTo(tb, editor);
        tb.setName(labels.getString("window.drawToolBar.title"));
        list.add(tb);
        tb = new JToolBar();
        this.addAttributesButtonsTo(tb, editor);
        tb.setName(labels.getString("window.attributesToolBar.title"));
        list.add(tb);
        tb = new JToolBar();
        ButtonFactory.addAlignmentButtonsTo(tb, editor);
        tb.setName(labels.getString("window.alignmentToolBar.title"));
        list.add(tb);
        return list;
    }

    @Override
    public void initView(Application a, View p) {
        if (a.isSharingToolsAmongViews()) {
            ((ODGView)p).setEditor(this.getSharedEditor());
        }
    }

    @Override
    public ActionMap createActionMap(Application a, @Nullable View v) {
        ActionMap m = super.createActionMap(a, v);
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        m.put("file.export", new ExportFileAction(a, v));
        AbstractViewAction aa = new ToggleViewPropertyAction(a, v, "gridVisible");
        m.put("view.toggleGrid", aa);
        drawLabels.configureAction(aa, "view.toggleGrid");
        for (double sf : scaleFactors) {
            aa = new ViewPropertyAction(a, v, "scaleFactor", Double.TYPE, new Double(sf));
            m.put((int)(sf * 100.0) + "%", aa);
            aa.putValue("Name", (int)(sf * 100.0) + " %");
        }
        return m;
    }

    @Override
    public URIChooser createOpenChooser(Application a, @Nullable View view) {
        final JFileURIChooser c = new JFileURIChooser();
        final HashMap<FileFilter, InputFormat> fileFilterInputFormatMap = new HashMap<FileFilter, InputFormat>();
        c.putClientProperty("ffInputFormatMap", fileFilterInputFormatMap);
        FileFilter firstFF = null;
        if (view == null) {
            view = new ODGView();
        }
        for (InputFormat format : ((ODGView)view).getDrawing().getInputFormats()) {
            FileFilter ff = format.getFileFilter();
            if (firstFF == null) {
                firstFF = ff;
            }
            fileFilterInputFormatMap.put(ff, format);
            c.addChoosableFileFilter(ff);
        }
        c.setFileFilter(firstFF);
        c.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("fileFilterChanged")) {
                    InputFormat inputFormat = (InputFormat)fileFilterInputFormatMap.get(evt.getNewValue());
                    c.setAccessory(inputFormat == null ? null : inputFormat.getInputFormatAccessory());
                }
            }
        });
        return c;
    }

    @Override
    public URIChooser createSaveChooser(Application a, @Nullable View view) {
        JFileURIChooser c;
        block1: {
            Iterator<OutputFormat> iterator;
            c = new JFileURIChooser();
            HashMap<FileFilter, OutputFormat> fileFilterOutputFormatMap = new HashMap<FileFilter, OutputFormat>();
            c.putClientProperty("ffOutputFormatMap", fileFilterOutputFormatMap);
            if (view == null) {
                view = new ODGView();
            }
            if (!(iterator = ((ODGView)view).getDrawing().getOutputFormats().iterator()).hasNext()) break block1;
            OutputFormat format = iterator.next();
            FileFilter ff = format.getFileFilter();
            fileFilterOutputFormatMap.put(ff, format);
            c.addChoosableFileFilter(ff);
        }
        return c;
    }

    @Override
    public URIChooser createExportChooser(Application a, @Nullable View view) {
        JFileURIChooser c;
        block1: {
            Iterator<OutputFormat> iterator;
            c = new JFileURIChooser();
            HashMap<FileFilter, OutputFormat> fileFilterOutputFormatMap = new HashMap<FileFilter, OutputFormat>();
            c.putClientProperty("ffExportFormatMap", fileFilterOutputFormatMap);
            if (view == null) {
                view = new ODGView();
            }
            if (!(iterator = ((ODGView)view).getDrawing().getOutputFormats().iterator()).hasNext()) break block1;
            OutputFormat format = iterator.next();
            FileFilter ff = format.getFileFilter();
            fileFilterOutputFormatMap.put(ff, format);
            c.addChoosableFileFilter(ff);
        }
        return c;
    }
}

