/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;
import org.jhotdraw.gui.plaf.palette.PaletteUtilities;

public class PaletteLabelUI
extends BasicLabelUI {
    protected static final PaletteLabelUI labelUI = new PaletteLabelUI();
    private static Rectangle iconR = new Rectangle();
    private static Rectangle textR = new Rectangle();
    private static Rectangle viewR = new Rectangle();
    private static Insets viewInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent c) {
        return labelUI;
    }

    @Override
    protected void installDefaults(JLabel b) {
        super.installDefaults(b);
        PaletteLookAndFeel.installBorder(b, "Label.border");
        PaletteLookAndFeel.installColorsAndFont(b, "Label.background", "Label.foreground", "Label.font");
        if (b.getClass().getName().endsWith("LabelUIResource")) {
            b.setFont(UIManager.getFont("Slider.labelFont"));
        }
    }

    @Override
    public void paint(Graphics gr, JComponent c) {
        Graphics2D g = (Graphics2D)gr;
        Object oldHints = PaletteUtilities.beginGraphics(g);
        super.paint(g, c);
        PaletteUtilities.endGraphics(g, oldHints);
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        Color c = UIManager.getColor("Label.disabledForeground");
        g.setColor(c != null ? c : l.getForeground());
        int accChar = -1;
        PaletteUtilities.drawString(g, s, accChar, textX, textY);
    }

    @Override
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int mnemIndex = l.getDisplayedMnemonicIndex();
        String style = (String)l.getClientProperty("Quaqua.Label.style");
        if (style != null) {
            if (style.equals("emboss") && UIManager.getColor("Label.embossForeground") != null) {
                g.setColor(UIManager.getColor("Label.embossForeground"));
                PaletteUtilities.drawString(g, s, mnemIndex, textX, textY + 1);
            } else if (style.equals("shadow") && UIManager.getColor("Label.shadowForeground") != null) {
                g.setColor(UIManager.getColor("Label.shadowForeground"));
                PaletteUtilities.drawString(g, s, mnemIndex, textX, textY + 1);
            }
        }
        g.setColor(l.getForeground());
        PaletteUtilities.drawString(g, s, mnemIndex, textX, textY);
    }

    @Override
    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        return SwingUtilities.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (!name.equals("JComponent.sizeVariant")) {
            super.propertyChange(evt);
        }
    }
}

