/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineFigure;
import org.jhotdraw.draw.connector.Connector;
import org.jhotdraw.draw.event.FigureAdapter;
import org.jhotdraw.draw.event.FigureEvent;
import org.jhotdraw.draw.handle.BezierNodeHandle;
import org.jhotdraw.draw.handle.BezierOutlineHandle;
import org.jhotdraw.draw.handle.ConnectionEndHandle;
import org.jhotdraw.draw.handle.ConnectionStartHandle;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.liner.Liner;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class LineConnectionFigure
extends LineFigure
implements ConnectionFigure {
    public static final String LINER_PROPERTY = "liner";
    private Connector startConnector;
    private Connector endConnector;
    @Nullable
    private Liner liner;
    private ConnectionHandler connectionHandler = new ConnectionHandler(this);

    @Override
    public void transform(AffineTransform tx) {
        super.transform(tx);
        this.updateConnection();
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        ArrayList<Handle> handles = new ArrayList<Handle>(this.getNodeCount());
        switch (detailLevel) {
            case -1: {
                handles.add(new BezierOutlineHandle(this, true));
                break;
            }
            case 0: {
                handles.add(new BezierOutlineHandle(this));
                if (this.getLiner() == null) {
                    int n = this.getNodeCount() - 1;
                    for (int i = 1; i < n; ++i) {
                        handles.add(new BezierNodeHandle(this, i));
                    }
                }
                handles.add(new ConnectionStartHandle(this));
                handles.add(new ConnectionEndHandle(this));
            }
        }
        return handles;
    }

    @Override
    public void setConnectable(boolean newValue) {
        super.setConnectable(false);
    }

    @Override
    public void updateConnection() {
        Point2D.Double end;
        Point2D.Double start;
        this.willChange();
        if (this.getStartConnector() != null && (start = this.getStartConnector().findStart(this)) != null) {
            this.setStartPoint(start);
        }
        if (this.getEndConnector() != null && (end = this.getEndConnector().findEnd(this)) != null) {
            this.setEndPoint(end);
        }
        this.changed();
    }

    @Override
    public void validate() {
        super.validate();
        this.lineout();
    }

    @Override
    public boolean canConnect(Connector start, Connector end) {
        return start.getOwner().isConnectable() && end.getOwner().isConnectable();
    }

    @Override
    public Connector getEndConnector() {
        return this.endConnector;
    }

    @Override
    public Figure getEndFigure() {
        return this.endConnector == null ? null : this.endConnector.getOwner();
    }

    @Override
    public Connector getStartConnector() {
        return this.startConnector;
    }

    @Override
    public Figure getStartFigure() {
        return this.startConnector == null ? null : this.startConnector.getOwner();
    }

    @Override
    public void setEndConnector(Connector newEnd) {
        if (newEnd != this.endConnector) {
            if (this.endConnector != null) {
                this.getEndFigure().removeFigureListener(this.connectionHandler);
                if (this.getStartFigure() != null && this.getDrawing() != null) {
                    this.handleDisconnect(this.getStartConnector(), this.getEndConnector());
                }
            }
            this.endConnector = newEnd;
            if (this.endConnector != null) {
                this.getEndFigure().addFigureListener(this.connectionHandler);
                if (this.getStartFigure() != null && this.getEndFigure() != null && this.getDrawing() != null) {
                    this.handleConnect(this.getStartConnector(), this.getEndConnector());
                    this.updateConnection();
                }
            }
        }
    }

    @Override
    public void setStartConnector(Connector newStart) {
        if (newStart != this.startConnector) {
            if (this.startConnector != null) {
                this.getStartFigure().removeFigureListener(this.connectionHandler);
                if (this.getEndFigure() != null) {
                    this.handleDisconnect(this.getStartConnector(), this.getEndConnector());
                }
            }
            this.startConnector = newStart;
            if (this.startConnector != null) {
                this.getStartFigure().addFigureListener(this.connectionHandler);
                if (this.getStartFigure() != null && this.getEndFigure() != null) {
                    this.handleConnect(this.getStartConnector(), this.getEndConnector());
                    this.updateConnection();
                }
            }
        }
    }

    @Override
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
        if (this.getStartConnector() != null && this.getEndConnector() != null) {
            this.handleConnect(this.getStartConnector(), this.getEndConnector());
            this.updateConnection();
        }
    }

    @Override
    public void removeNotify(Drawing drawing) {
        if (this.getStartConnector() != null && this.getEndConnector() != null) {
            this.handleDisconnect(this.getStartConnector(), this.getEndConnector());
        }
        super.removeNotify(drawing);
    }

    protected void handleDisconnect(Connector start, Connector end) {
    }

    protected void handleConnect(Connector start, Connector end) {
    }

    @Override
    public LineConnectionFigure clone() {
        LineConnectionFigure that = (LineConnectionFigure)super.clone();
        that.connectionHandler = new ConnectionHandler(that);
        if (this.liner != null) {
            that.liner = this.liner.clone();
        }
        if (this.startConnector != null) {
            that.startConnector = (Connector)this.startConnector.clone();
            that.getStartFigure().addFigureListener(that.connectionHandler);
        }
        if (this.endConnector != null) {
            that.endConnector = (Connector)this.endConnector.clone();
            that.getEndFigure().addFigureListener(that.connectionHandler);
        }
        if (that.startConnector != null && that.endConnector != null) {
            that.updateConnection();
        }
        return that;
    }

    @Override
    public void remap(Map<Figure, Figure> oldToNew, boolean disconnectIfNotInMap) {
        this.willChange();
        super.remap(oldToNew, disconnectIfNotInMap);
        Figure newStartFigure = null;
        Figure newEndFigure = null;
        if (this.getStartFigure() != null && (newStartFigure = oldToNew.get(this.getStartFigure())) == null && !disconnectIfNotInMap) {
            newStartFigure = this.getStartFigure();
        }
        if (this.getEndFigure() != null && (newEndFigure = oldToNew.get(this.getEndFigure())) == null && !disconnectIfNotInMap) {
            newEndFigure = this.getEndFigure();
        }
        if (newStartFigure != null) {
            this.setStartConnector(newStartFigure.findCompatibleConnector(this.getStartConnector(), true));
        } else if (disconnectIfNotInMap) {
            this.setStartConnector(null);
        }
        if (newEndFigure != null) {
            this.setEndConnector(newEndFigure.findCompatibleConnector(this.getEndConnector(), false));
        } else if (disconnectIfNotInMap) {
            this.setEndConnector(null);
        }
        this.updateConnection();
        this.changed();
    }

    @Override
    public boolean canConnect(Connector start) {
        return start.getOwner().isConnectable();
    }

    @Override
    public boolean handleMouseClick(Point2D.Double p, MouseEvent evt, DrawingView view) {
        if (this.getLiner() == null && evt.getClickCount() == 2) {
            this.willChange();
            final int index = this.splitSegment(p, (float)(5.0 / view.getScaleFactor()));
            if (index != -1) {
                final BezierPath.Node newNode = this.getNode(index);
                this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        LineConnectionFigure.this.willChange();
                        LineConnectionFigure.this.addNode(index, newNode);
                        LineConnectionFigure.this.changed();
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        LineConnectionFigure.this.willChange();
                        LineConnectionFigure.this.removeNode(index);
                        LineConnectionFigure.this.changed();
                    }
                });
                this.changed();
                return true;
            }
        }
        return false;
    }

    @Override
    protected void readPoints(DOMInput in) throws IOException {
        super.readPoints(in);
        in.openElement("startConnector");
        this.setStartConnector((Connector)in.readObject());
        in.closeElement();
        in.openElement("endConnector");
        this.setEndConnector((Connector)in.readObject());
        in.closeElement();
    }

    @Override
    public void read(DOMInput in) throws IOException {
        this.readAttributes(in);
        this.readLiner(in);
        this.readPoints(in);
    }

    protected void readLiner(DOMInput in) throws IOException {
        if (in.getElementCount(LINER_PROPERTY) > 0) {
            in.openElement(LINER_PROPERTY);
            this.liner = (Liner)in.readObject();
            in.closeElement();
        } else {
            this.liner = null;
        }
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        this.writePoints(out);
        this.writeAttributes(out);
        this.writeLiner(out);
    }

    protected void writeLiner(DOMOutput out) throws IOException {
        if (this.liner != null) {
            out.openElement(LINER_PROPERTY);
            out.writeObject(this.liner);
            out.closeElement();
        }
    }

    @Override
    protected void writePoints(DOMOutput out) throws IOException {
        super.writePoints(out);
        out.openElement("startConnector");
        out.writeObject(this.getStartConnector());
        out.closeElement();
        out.openElement("endConnector");
        out.writeObject(this.getEndConnector());
        out.closeElement();
    }

    @Override
    public void setLiner(Liner newValue) {
        Liner oldValue = this.liner;
        this.liner = newValue;
        this.firePropertyChange(LINER_PROPERTY, oldValue, newValue);
    }

    @Override
    public void setNode(int index, BezierPath.Node p) {
        if (index != 0 && index != this.getNodeCount() - 1) {
            Point2D.Double end;
            Point2D.Double start;
            if (this.getStartConnector() != null && (start = this.getStartConnector().findStart(this)) != null) {
                this.setStartPoint(start);
            }
            if (this.getEndConnector() != null && (end = this.getEndConnector().findEnd(this)) != null) {
                this.setEndPoint(end);
            }
        }
        super.setNode(index, p);
    }

    @Override
    public void lineout() {
        if (this.liner != null) {
            this.liner.lineout(this);
        }
    }

    @Override
    public BezierPath getBezierPath() {
        return this.path;
    }

    @Override
    public Liner getLiner() {
        return this.liner;
    }

    @Override
    public void setStartPoint(Point2D.Double p) {
        this.setPoint(0, p);
    }

    @Override
    public void setPoint(int index, Point2D.Double p) {
        this.setPoint(index, 0, p);
    }

    @Override
    public void setEndPoint(Point2D.Double p) {
        this.setPoint(this.getNodeCount() - 1, p);
    }

    public void reverseConnection() {
        if (this.startConnector != null && this.endConnector != null) {
            this.handleDisconnect(this.startConnector, this.endConnector);
            Connector tmpC = this.startConnector;
            this.startConnector = this.endConnector;
            this.endConnector = tmpC;
            Point2D.Double tmpP = this.getStartPoint();
            this.setStartPoint(this.getEndPoint());
            this.setEndPoint(tmpP);
            this.handleConnect(this.startConnector, this.endConnector);
            this.updateConnection();
        }
    }

    private static class ConnectionHandler
    extends FigureAdapter
    implements Serializable {
        private LineConnectionFigure owner;

        private ConnectionHandler(LineConnectionFigure owner) {
            this.owner = owner;
        }

        @Override
        public void figureRemoved(FigureEvent evt) {
            this.owner.fireFigureRequestRemove();
        }

        @Override
        public void figureChanged(FigureEvent e) {
            if (!(this.owner.isChanging() || e.getSource() != this.owner.getStartFigure() && e.getSource() != this.owner.getEndFigure())) {
                this.owner.willChange();
                this.owner.updateConnection();
                this.owner.changed();
            }
        }
    }
}

