/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action.file;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractApplicationAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.net.URIUtil;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.prefs.PreferencesUtil;

public class OpenFileAction
extends AbstractApplicationAction {
    public static final String ID = "file.open";

    public OpenFileAction(Application app) {
        super(app);
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    protected URIChooser getChooser(View view) {
        return this.getApplication().getOpenChooser(null);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Application app = this.getApplication();
        if (app.isEnabled()) {
            boolean disposeView;
            View view;
            app.setEnabled(false);
            View emptyView = app.getActiveView();
            if (emptyView == null || !emptyView.isEmpty() || !emptyView.isEnabled()) {
                emptyView = null;
            }
            if (emptyView == null) {
                view = app.createView();
                app.add(view);
                disposeView = true;
            } else {
                view = emptyView;
                disposeView = false;
            }
            URIChooser chooser = this.getChooser(view);
            chooser.setDialogType(0);
            if (this.showDialog(chooser, app.getComponent()) == 0) {
                app.show(view);
                this.openViewFromURI(view, chooser.getSelectedURI(), chooser);
            } else {
                if (disposeView) {
                    app.dispose(view);
                }
                app.setEnabled(true);
            }
        }
    }

    protected void openViewFromURI(final View view, final URI uri, final URIChooser chooser) {
        final Application app = this.getApplication();
        app.setEnabled(true);
        view.setEnabled(false);
        int multipleOpenId = 1;
        for (View aView : app.views()) {
            if (aView == view || !aView.isEmpty()) continue;
            multipleOpenId = Math.max(multipleOpenId, aView.getMultipleOpenId() + 1);
        }
        view.setMultipleOpenId(multipleOpenId);
        view.setEnabled(false);
        view.execute(new Worker(){

            public Object construct() throws IOException {
                boolean exists = true;
                try {
                    exists = new File(uri).exists();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (exists) {
                    view.read(uri, chooser);
                    return null;
                }
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                throw new IOException(labels.getFormatted("file.open.fileDoesNotExist.message", URIUtil.getName(uri)));
            }

            protected void done(Object value) {
                Application app2 = OpenFileAction.this.getApplication();
                view.setURI(uri);
                view.setEnabled(true);
                Frame w = (Frame)SwingUtilities.getWindowAncestor(view.getComponent());
                if (w != null) {
                    w.setExtendedState(w.getExtendedState() & 0xFFFFFFFE);
                    w.toFront();
                }
                view.getComponent().requestFocus();
                app2.addRecentURI(uri);
                app2.setEnabled(true);
            }

            @Override
            protected void failed(Throwable value) {
                value.printStackTrace();
                view.setEnabled(true);
                app.setEnabled(true);
                String message = value.getMessage() != null ? value.getMessage() : value.toString();
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                JSheet.showMessageSheet((Component)view.getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + "<b>" + labels.getFormatted("file.open.couldntOpen.message", URIUtil.getName(uri)) + "</b><p>" + (message == null ? "" : message)), 0);
            }
        });
    }

    public int showDialog(URIChooser chooser, Component parent) {
        Component finalParent = parent;
        final int[] returnValue = new int[1];
        final JDialog dialog = this.createDialog(chooser, finalParent);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                returnValue[0] = 1;
            }
        });
        chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("CancelSelection")) {
                    returnValue[0] = 1;
                    dialog.setVisible(false);
                } else if (e.getActionCommand().equals("ApproveSelection")) {
                    returnValue[0] = 0;
                    dialog.setVisible(false);
                }
            }
        });
        returnValue[0] = -1;
        chooser.rescanCurrentDirectory();
        dialog.setVisible(true);
        dialog.removeAll();
        dialog.dispose();
        return returnValue[0];
    }

    protected JDialog createDialog(URIChooser chooser, Component parent) throws HeadlessException {
        boolean supportsWindowDecorations;
        String title = chooser.getDialogTitle();
        if (chooser instanceof JFileChooser) {
            ((JFileChooser)((Object)chooser)).getAccessibleContext().setAccessibleDescription(title);
        }
        Window window = parent == null || parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)window, title, true);
        dialog.setComponentOrientation(chooser.getComponent().getComponentOrientation());
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)chooser.getComponent(), "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            dialog.getRootPane().setWindowDecorationStyle(6);
        }
        Preferences prefs = PreferencesUtil.userNodeForPackage(this.getApplication().getModel().getClass());
        PreferencesUtil.installFramePrefsHandler(prefs, "openChooser", dialog);
        return dialog;
    }
}

