/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action.file;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractViewAction;
import org.jhotdraw.gui.JFileURIChooser;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.net.URIUtil;
import org.jhotdraw.util.ResourceBundleUtil;

public class ExportFileAction
extends AbstractViewAction {
    public static final String ID = "file.export";
    private Component oldFocusOwner;

    public ExportFileAction(Application app, @Nullable View view) {
        super(app, view);
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        final View view = this.getActiveView();
        if (view.isEnabled()) {
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
            this.oldFocusOwner = SwingUtilities.getWindowAncestor(view.getComponent()).getFocusOwner();
            view.setEnabled(false);
            URIChooser fileChooser = this.getApplication().getExportChooser(view);
            JSheet.showSheet(fileChooser, (Component)view.getComponent(), labels.getString("filechooser.export"), new SheetListener(){

                @Override
                public void optionSelected(SheetEvent evt) {
                    if (evt.getOption() == 0) {
                        URI uri = evt.getChooser().getSelectedURI();
                        if (evt.getChooser() instanceof JFileURIChooser) {
                            ExportFileAction.this.exportView(view, uri, evt.getChooser());
                        } else {
                            ExportFileAction.this.exportView(view, uri, null);
                        }
                    } else {
                        view.setEnabled(true);
                        if (ExportFileAction.this.oldFocusOwner != null) {
                            ExportFileAction.this.oldFocusOwner.requestFocus();
                        }
                    }
                }
            });
        }
    }

    protected void exportView(final View view, final URI uri, final @Nullable URIChooser chooser) {
        view.execute(new Worker(){

            protected Object construct() throws IOException {
                view.write(uri, chooser);
                return null;
            }

            @Override
            protected void failed(Throwable value) {
                System.out.flush();
                value.printStackTrace();
                JSheet.showMessageSheet((Component)view.getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + "<b>Couldn't export to the file \"" + URIUtil.getName(uri) + "\".<p>Reason: " + value), 0);
            }

            @Override
            protected void finished() {
                view.setEnabled(true);
                SwingUtilities.getWindowAncestor(view.getComponent()).toFront();
                if (ExportFileAction.this.oldFocusOwner != null) {
                    ExportFileAction.this.oldFocusOwner.requestFocus();
                }
            }
        });
    }
}

