/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action.edit;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.jhotdraw.beans.WeakPropertyChangeListener;
import org.jhotdraw.gui.EditableComponent;
import org.jhotdraw.util.ResourceBundleUtil;

public class DeleteAction
extends TextAction {
    public static final String ID = "edit.delete";
    @Nullable
    private JComponent target;
    private PropertyChangeListener propertyHandler;

    public DeleteAction() {
        this((JComponent)null);
    }

    public DeleteAction(@Nullable JComponent target) {
        super(ID);
        this.target = target;
        if (target != null) {
            this.propertyHandler = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("enabled")) {
                        DeleteAction.this.setEnabled((Boolean)evt.getNewValue());
                    }
                }
            };
            target.addPropertyChangeListener(new WeakPropertyChangeListener(this.propertyHandler));
        }
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JComponent c = this.target;
        if (c == null && KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() instanceof JComponent) {
            c = (JComponent)KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        }
        if (c != null && c.isEnabled()) {
            if (c instanceof EditableComponent) {
                ((EditableComponent)((Object)c)).delete();
            } else {
                this.deleteNextChar(evt);
            }
        }
    }

    public void deleteNextChar(ActionEvent e) {
        JTextComponent c = this.getTextComponent(e);
        boolean beep = true;
        if (c != null && c.isEditable()) {
            try {
                Document doc = c.getDocument();
                Caret caret = c.getCaret();
                int dot = caret.getDot();
                int mark = caret.getMark();
                if (dot != mark) {
                    doc.remove(Math.min(dot, mark), Math.abs(dot - mark));
                    beep = false;
                } else if (dot < doc.getLength()) {
                    doc.remove(dot, 1);
                    beep = false;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (beep) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

