/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.jhotdraw.app.AbstractApplication;
import org.jhotdraw.app.ApplicationModel;
import org.jhotdraw.app.MenuBuilder;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.ActionUtil;
import org.jhotdraw.app.action.app.AboutAction;
import org.jhotdraw.app.action.app.ExitAction;
import org.jhotdraw.app.action.file.ClearRecentFilesMenuAction;
import org.jhotdraw.app.action.window.ArrangeWindowsAction;
import org.jhotdraw.app.action.window.FocusWindowAction;
import org.jhotdraw.app.action.window.MaximizeWindowAction;
import org.jhotdraw.app.action.window.MinimizeWindowAction;
import org.jhotdraw.app.action.window.ToggleToolBarAction;
import org.jhotdraw.gui.Arrangeable;
import org.jhotdraw.gui.JMDIDesktopPane;
import org.jhotdraw.net.URIUtil;
import org.jhotdraw.util.ReversedList;
import org.jhotdraw.util.prefs.PreferencesUtil;

public class MDIApplication
extends AbstractApplication {
    private JFrame parentFrame;
    private JScrollPane scrollPane;
    private JMDIDesktopPane desktopPane;
    private Preferences prefs;
    private LinkedList<Action> toolBarActions;

    @Override
    public void init() {
        super.init();
        this.initLookAndFeel();
        this.prefs = PreferencesUtil.userNodeForPackage(this.getModel() == null ? this.getClass() : this.getModel().getClass());
        this.initLabels();
        this.parentFrame = new JFrame(this.getName());
        this.parentFrame.setDefaultCloseOperation(0);
        this.parentFrame.setPreferredSize(new Dimension(600, 400));
        this.desktopPane = new JMDIDesktopPane();
        this.desktopPane.setTransferHandler(new DropFileTransferHandler());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.desktopPane);
        this.toolBarActions = new LinkedList();
        this.setActionMap(this.createModelActionMap(this.model));
        this.parentFrame.getContentPane().add(this.wrapDesktopPane(this.scrollPane, this.toolBarActions));
        this.parentFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MDIApplication.this.getAction(null, "application.exit").actionPerformed(new ActionEvent(MDIApplication.this.parentFrame, 1001, "windowClosing"));
            }
        });
        this.parentFrame.setJMenuBar(this.createMenuBar(null));
        PreferencesUtil.installFramePrefsHandler(this.prefs, "parentFrame", this.parentFrame);
        this.parentFrame.setVisible(true);
        this.model.initApplication(this);
    }

    protected ActionMap createModelActionMap(ApplicationModel mo) {
        ActionMap rootMap = new ActionMap();
        rootMap.put("application.about", new AboutAction(this));
        rootMap.put("application.exit", new ExitAction(this));
        rootMap.put("file.clearRecentFiles", new ClearRecentFilesMenuAction(this));
        rootMap.put("window.maximize", new MaximizeWindowAction(this, null));
        rootMap.put("window.minimize", new MinimizeWindowAction(this, null));
        rootMap.put("window.arrangeVertical", new ArrangeWindowsAction(this.desktopPane, Arrangeable.Arrangement.VERTICAL));
        rootMap.put("window.arrangeHorizontal", new ArrangeWindowsAction(this.desktopPane, Arrangeable.Arrangement.HORIZONTAL));
        rootMap.put("window.arrangeCascade", new ArrangeWindowsAction(this.desktopPane, Arrangeable.Arrangement.CASCADE));
        ActionMap moMap = mo.createActionMap(this, null);
        moMap.setParent(rootMap);
        return moMap;
    }

    @Override
    protected ActionMap createViewActionMap(View v) {
        ActionMap intermediateMap = new ActionMap();
        intermediateMap.put("window.focus", new FocusWindowAction(v));
        ActionMap vMap = this.model.createActionMap(this, v);
        vMap.setParent(intermediateMap);
        intermediateMap.setParent(this.getActionMap(null));
        return vMap;
    }

    @Override
    public void launch(String[] args) {
        super.launch(args);
    }

    @Override
    public void configure(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "false");
        System.setProperty("com.apple.macos.useScreenMenuBar", "false");
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        System.setProperty("swing.aatext", "true");
    }

    protected void initLookAndFeel() {
        try {
            String lafName = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(lafName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (UIManager.getString("OptionPane.css") == null) {
            UIManager.put("OptionPane.css", "<head><style type=\"text/css\">b { font: 13pt \"Dialog\" }p { font: 11pt \"Dialog\"; margin-top: 8px }</style></head>");
        }
    }

    @Override
    public void show(final View v) {
        if (!v.isShowing()) {
            boolean moved;
            v.setShowing(true);
            final JInternalFrame f = new JInternalFrame();
            f.setDefaultCloseOperation(0);
            f.setClosable(this.getAction(v, "file.close") != null);
            f.setMaximizable(true);
            f.setResizable(true);
            f.setIconifiable(false);
            f.setSize(new Dimension(400, 400));
            this.updateViewTitle(v, f);
            PreferencesUtil.installInternalFramePrefsHandler(this.prefs, "view", f, this.desktopPane);
            Point loc = new Point(this.desktopPane.getInsets().left, this.desktopPane.getInsets().top);
            block4: do {
                moved = false;
                for (View aView : this.views()) {
                    if (aView == v || !aView.isShowing() || !SwingUtilities.getRootPane(aView.getComponent()).getParent().getLocation().equals(loc)) continue;
                    Point offset = SwingUtilities.convertPoint(SwingUtilities.getRootPane(aView.getComponent()), 0, 0, SwingUtilities.getRootPane(aView.getComponent()).getParent());
                    loc.x += Math.max(offset.x, offset.y);
                    loc.y += Math.max(offset.x, offset.y);
                    moved = true;
                    continue block4;
                }
            } while (moved);
            f.setLocation(loc);
            f.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent evt) {
                    MDIApplication.this.getAction(v, "file.close").actionPerformed(new ActionEvent(f, 1001, "windowClosing"));
                }

                @Override
                public void internalFrameClosed(InternalFrameEvent evt) {
                    v.stop();
                }
            });
            v.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    if (name == "hasUnsavedChanges" || name == "uri") {
                        MDIApplication.this.updateViewTitle(v, f);
                    }
                }
            });
            f.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    if (name.equals("selected")) {
                        if (evt.getNewValue().equals(Boolean.TRUE)) {
                            MDIApplication.this.setActiveView(v);
                        } else if (v == MDIApplication.this.getActiveView()) {
                            MDIApplication.this.setActiveView(null);
                        }
                    }
                }
            });
            f.getContentPane().add(v.getComponent());
            f.setVisible(true);
            this.desktopPane.add(f);
            if (this.desktopPane.getComponentCount() == 1) {
                try {
                    f.setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            f.toFront();
            try {
                f.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            v.getComponent().requestFocusInWindow();
            v.start();
        }
    }

    @Override
    public void hide(View v) {
        if (v.isShowing()) {
            JInternalFrame f = (JInternalFrame)SwingUtilities.getRootPane(v.getComponent()).getParent();
            if (this.getActiveView() == v) {
                this.setActiveView(null);
            }
            f.setVisible(false);
            f.remove(v.getComponent());
            f.setJMenuBar(null);
            this.desktopPane.remove(f);
            f.dispose();
        }
    }

    @Override
    public boolean isSharingToolsAmongViews() {
        return true;
    }

    @Override
    public Component getComponent() {
        return this.parentFrame;
    }

    protected Component wrapDesktopPane(Component c, LinkedList<Action> toolBarActions) {
        if (this.getModel() != null) {
            int id = 0;
            for (JToolBar tb : new ReversedList<JToolBar>(this.getModel().createToolBars(this, null))) {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)tb, "North");
                panel.add(c, "Center");
                c = panel;
                PreferencesUtil.installToolBarPrefsHandler(this.prefs, "toolbar." + ++id, tb);
                toolBarActions.addFirst(new ToggleToolBarAction(tb, tb.getName()));
            }
        }
        return c;
    }

    protected JMenuBar createMenuBar(@Nullable View v) {
        JMenuBar mb = new JMenuBar();
        JMenu fileMenu = null;
        JMenu editMenu = null;
        JMenu helpMenu = null;
        JMenu viewMenu = null;
        JMenu windowMenu = null;
        String fileMenuText = this.labels.getString("file.text");
        String editMenuText = this.labels.getString("edit.text");
        String viewMenuText = this.labels.getString("view.text");
        String windowMenuText = this.labels.getString("window.text");
        String helpMenuText = this.labels.getString("help.text");
        LinkedList<JMenu> ll = new LinkedList<JMenu>();
        this.getModel().getMenuBuilder().addOtherMenus(ll, this, v);
        for (JMenu mm : ll) {
            String text = mm.getText();
            if (text == null) {
                mm.setText("-null-");
            } else {
                if (text.equals(fileMenuText)) {
                    fileMenu = mm;
                    continue;
                }
                if (text.equals(editMenuText)) {
                    editMenu = mm;
                    continue;
                }
                if (text.equals(viewMenuText)) {
                    viewMenu = mm;
                    continue;
                }
                if (text.equals(windowMenuText)) {
                    windowMenu = mm;
                    continue;
                }
                if (text.equals(helpMenuText)) {
                    helpMenu = mm;
                    continue;
                }
            }
            mb.add(mm);
        }
        if (fileMenu == null) {
            fileMenu = this.createFileMenu(v);
        }
        if (editMenu == null) {
            editMenu = this.createEditMenu(v);
        }
        if (viewMenu == null) {
            viewMenu = this.createViewMenu(v);
        }
        if (windowMenu == null) {
            windowMenu = this.createWindowMenu(v);
        }
        if (helpMenu == null) {
            helpMenu = this.createHelpMenu(v);
        }
        if (fileMenu != null) {
            mb.add((Component)fileMenu, 0);
        }
        if (editMenu != null) {
            mb.add((Component)editMenu, Math.min(1, mb.getComponentCount()));
        }
        if (viewMenu != null) {
            mb.add((Component)viewMenu, Math.min(2, mb.getComponentCount()));
        }
        if (windowMenu != null) {
            mb.add(windowMenu);
        }
        if (helpMenu != null) {
            mb.add(helpMenu);
        }
        return mb;
    }

    @Override
    @Nullable
    public JMenu createFileMenu(View view) {
        JMenu m = new JMenu();
        this.labels.configureMenu(m, "file");
        MenuBuilder mb = this.model.getMenuBuilder();
        mb.addClearFileItems(m, this, view);
        mb.addNewFileItems(m, this, view);
        mb.addNewWindowItems(m, this, view);
        mb.addLoadFileItems(m, this, view);
        mb.addOpenFileItems(m, this, view);
        if (this.getAction(view, "file.load") != null || this.getAction(view, "file.open") != null || this.getAction(view, "file.loadDirectory") != null || this.getAction(view, "file.openDirectory") != null) {
            m.add(this.createOpenRecentFileMenu(view));
        }
        this.maybeAddSeparator(m);
        mb.addCloseFileItems(m, this, view);
        mb.addSaveFileItems(m, this, view);
        mb.addExportFileItems(m, this, view);
        mb.addPrintFileItems(m, this, view);
        mb.addOtherFileItems(m, this, view);
        this.maybeAddSeparator(m);
        mb.addExitItems(m, this, view);
        return m.getItemCount() == 0 ? null : m;
    }

    protected void updateViewTitle(View v, JInternalFrame f) {
        URI uri = v.getURI();
        String title = uri == null ? this.labels.getString("unnamedFile") : URIUtil.getName(uri);
        if (v.hasUnsavedChanges()) {
            title = title + "*";
        }
        v.setTitle(this.labels.getFormatted("internalFrame.title", title, this.getName(), v.getMultipleOpenId()));
        f.setTitle(v.getTitle());
    }

    @Override
    @Nullable
    public JMenu createViewMenu(View view) {
        JMenu m = new JMenu();
        this.labels.configureMenu(m, "view");
        MenuBuilder mb = this.model.getMenuBuilder();
        mb.addOtherViewItems(m, this, view);
        return m.getItemCount() > 0 ? m : null;
    }

    @Override
    @Nullable
    public JMenu createWindowMenu(View view) {
        JMenu m;
        JMenu windowMenu = m = new JMenu();
        this.labels.configureMenu(m, "window");
        this.addAction(m, view, "window.arrangeCascade");
        this.addAction(m, view, "window.arrangeVertical");
        this.addAction(m, view, "window.arrangeHorizontal");
        this.maybeAddSeparator(m);
        for (View pr : this.views()) {
            this.addAction(m, view, "window.focus");
        }
        if (this.toolBarActions.size() > 0) {
            this.maybeAddSeparator(m);
            for (Action a : this.toolBarActions) {
                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                ActionUtil.configureJCheckBoxMenuItem(cbmi, a);
                this.addMenuItem(m, cbmi);
            }
        }
        MenuBuilder mb = this.model.getMenuBuilder();
        mb.addOtherWindowItems(m, this, view);
        this.addPropertyChangeListener(new WindowMenuHandler(windowMenu, view));
        return m.getItemCount() == 0 ? null : m;
    }

    @Override
    @Nullable
    public JMenu createEditMenu(View view) {
        JMenu m = new JMenu();
        this.labels.configureMenu(m, "edit");
        MenuBuilder mb = this.model.getMenuBuilder();
        mb.addUndoItems(m, this, view);
        this.maybeAddSeparator(m);
        mb.addClipboardItems(m, this, view);
        this.maybeAddSeparator(m);
        mb.addSelectionItems(m, this, view);
        this.maybeAddSeparator(m);
        mb.addFindItems(m, this, view);
        this.maybeAddSeparator(m);
        mb.addOtherEditItems(m, this, view);
        this.maybeAddSeparator(m);
        mb.addPreferencesItems(m, this, view);
        return m.getItemCount() == 0 ? null : m;
    }

    @Override
    public JMenu createHelpMenu(View view) {
        JMenu m = new JMenu();
        this.labels.configureMenu(m, "help");
        MenuBuilder mb = this.model.getMenuBuilder();
        mb.addHelpItems(m, this, view);
        mb.addAboutItems(m, this, view);
        return m.getItemCount() == 0 ? null : m;
    }

    private class DropFileTransferHandler
    extends TransferHandler {
        private DropFileTransferHandler() {
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            Action a = MDIApplication.this.getAction(null, "application.openFile");
            if (a == null) {
                return false;
            }
            for (DataFlavor f : transferFlavors) {
                if (!f.isFlavorJavaFileListType()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            Action a = MDIApplication.this.getAction(null, "application.openFile");
            if (a == null) {
                return false;
            }
            try {
                List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                for (File f : files) {
                    a.actionPerformed(new ActionEvent(MDIApplication.this.desktopPane, 1001, f.toString()));
                }
                return true;
            }
            catch (UnsupportedFlavorException ex) {
                return false;
            }
            catch (IOException ex) {
                return false;
            }
        }
    }

    private class WindowMenuHandler
    implements PropertyChangeListener {
        private JMenu windowMenu;
        @Nullable
        private View view;

        public WindowMenuHandler(@Nullable JMenu windowMenu, View view) {
            this.windowMenu = windowMenu;
            this.view = view;
            MDIApplication.this.addPropertyChangeListener(this);
            this.updateWindowMenu();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == "viewCount" || name == "paletteCount") {
                this.updateWindowMenu();
            }
        }

        protected void updateWindowMenu() {
            JMenu m = this.windowMenu;
            m.removeAll();
            m.add(MDIApplication.this.getAction(this.view, "window.arrangeCascade"));
            m.add(MDIApplication.this.getAction(this.view, "window.arrangeVertical"));
            m.add(MDIApplication.this.getAction(this.view, "window.arrangeHorizontal"));
            m.addSeparator();
            for (View pr : MDIApplication.this.views()) {
                if (MDIApplication.this.getAction(pr, "window.focus") == null) continue;
                m.add(MDIApplication.this.getAction(pr, "window.focus"));
            }
            if (MDIApplication.this.toolBarActions.size() > 0) {
                m.addSeparator();
                for (Action a : MDIApplication.this.toolBarActions) {
                    JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                    ActionUtil.configureJCheckBoxMenuItem(cbmi, a);
                    m.add(cbmi);
                }
            }
        }
    }
}

