/*
 * Decompiled with CFR 0.152.
 */
package org.hecl.net;

import java.io.UnsupportedEncodingException;

public class Base64 {
    private static int lineLength;
    private static final char fillchar = '=';
    private static char[] vc;
    private static int[] cv;

    public static String encode(byte[] b) {
        return Base64.encode2sb(b).toString();
    }

    public static StringBuffer encode2sb(byte[] b) {
        int lines;
        int outputLength = (b.length + 2) / 3 * 4;
        if (lineLength != 0 && (lines = (outputLength + lineLength - 1) / lineLength - 1) > 0) {
            outputLength += lines;
        }
        StringBuffer sb = new StringBuffer(outputLength);
        int linePos = 0;
        int len = b.length / 3 * 3;
        int leftover = b.length - len;
        for (int i = 0; i < len; i += 3) {
            if ((linePos += 4) > lineLength) {
                linePos = 4;
            }
            int combined = b[i] & 0xFF;
            combined <<= 8;
            combined |= b[i + 1] & 0xFF;
            combined <<= 8;
            int c3 = (combined |= b[i + 2] & 0xFF) & 0x3F;
            int c2 = (combined >>>= 6) & 0x3F;
            int c1 = (combined >>>= 6) & 0x3F;
            int c0 = (combined >>>= 6) & 0x3F;
            sb.append(vc[c0]);
            sb.append(vc[c1]);
            sb.append(vc[c2]);
            sb.append(vc[c3]);
        }
        switch (leftover) {
            default: {
                break;
            }
            case 1: {
                if ((linePos += 4) > lineLength) {
                    linePos = 4;
                }
                sb.append(Base64.encode(new byte[]{b[len], 0, 0}).substring(0, 2));
                sb.append('=');
                sb.append('=');
                break;
            }
            case 2: {
                if ((linePos += 4) > lineLength) {
                    linePos = 4;
                }
                sb.append(Base64.encode(new byte[]{b[len], b[len + 1], 0}).substring(0, 3));
                sb.append('=');
            }
        }
        if (outputLength != sb.length()) {
            // empty if block
        }
        return sb;
    }

    public static byte[] decode(String s) {
        byte[] b = new byte[s.length() / 4 * 3];
        int cycle = 0;
        int combined = 0;
        int j = 0;
        int len = s.length();
        int dummies = 0;
        block10: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            int value = c <= '\u00ff' ? cv[c] : -1;
            switch (value) {
                case -1: {
                    continue block10;
                }
                case -2: {
                    value = 0;
                    ++dummies;
                }
                default: {
                    switch (cycle) {
                        case 0: {
                            combined = value;
                            cycle = 1;
                            continue block10;
                        }
                        case 1: {
                            combined <<= 6;
                            combined |= value;
                            cycle = 2;
                            continue block10;
                        }
                        case 2: {
                            combined <<= 6;
                            combined |= value;
                            cycle = 3;
                            continue block10;
                        }
                        case 3: {
                            combined <<= 6;
                            b[j + 2] = (byte)(combined |= value);
                            b[j + 1] = (byte)(combined >>>= 8);
                            b[j] = (byte)(combined >>>= 8);
                            j += 3;
                            cycle = 0;
                        }
                    }
                }
            }
        }
        if (b.length != (j -= dummies)) {
            byte[] b2 = new byte[j];
            System.arraycopy(b, 0, b2, 0, j);
            b = b2;
        }
        return b;
    }

    public static String decode(String s, String encoding) throws UnsupportedEncodingException {
        return new String(Base64.decode(s), encoding);
    }

    public static void setLineLength(int length) {
        lineLength = length / 4 * 4;
    }

    static {
        int i;
        lineLength = 72;
        vc = new char[64];
        cv = new int[256];
        for (i = 0; i <= 25; ++i) {
            Base64.vc[i] = (char)(65 + i);
        }
        for (i = 0; i <= 25; ++i) {
            Base64.vc[i + 26] = (char)(97 + i);
        }
        for (i = 0; i <= 9; ++i) {
            Base64.vc[i + 52] = (char)(48 + i);
        }
        Base64.vc[62] = 43;
        Base64.vc[63] = 47;
        for (i = 0; i < 256; ++i) {
            Base64.cv[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            Base64.cv[Base64.vc[i]] = i;
        }
        Base64.cv[61] = -2;
    }
}

