/*
 * Decompiled with CFR 0.152.
 */
package org.hecl.files;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.Thing;

public class HeclFileUtils {
    public static Thing readFile(String filename) throws HeclException, IOException {
        File realfn = new File(filename).getAbsoluteFile();
        InputStreamReader eingabestrom = new InputStreamReader((InputStream)new FileInputStream(realfn), "UTF-8");
        BufferedReader eingabe = new BufferedReader(eingabestrom);
        StringBuffer sb = new StringBuffer(1024);
        boolean isEOF = false;
        do {
            String zeile;
            if ((zeile = eingabe.readLine()) != null) {
                sb.append(zeile);
                sb.append("\n");
                continue;
            }
            isEOF = true;
        } while (!isEOF);
        eingabe.close();
        eingabestrom.close();
        return new Thing(sb.toString());
    }

    public static Thing readFileFromDis(DataInputStream dis) throws IOException {
        int bsize = 1024;
        byte[] buf = new byte[bsize];
        byte[] acc = null;
        byte[] oldacc = null;
        int len = 0;
        int pos = 0;
        int i = 1;
        while ((len = dis.read(buf)) > -1) {
            oldacc = acc;
            acc = new byte[i * bsize];
            if (oldacc != null) {
                System.arraycopy(oldacc, 0, acc, 0, (i - 1) * bsize);
            }
            System.arraycopy(buf, 0, acc, pos, len);
            pos += len;
            ++i;
        }
        return new Thing(new String(acc, 0, pos));
    }

    public static void sourceFile(Interp interp, String filename) throws HeclException {
        interp.currentFile = new Thing(filename);
        try {
            interp.eval(HeclFileUtils.readFile(filename));
        }
        catch (HeclException he) {
            throw he;
        }
        catch (Exception e) {
            throw new HeclException("Error while running '" + filename + "': " + e.toString());
        }
    }
}

