/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import java.util.Enumeration;
import java.util.Vector;
import org.hecl.CodeThing;
import org.hecl.GroupThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.NumberThing;
import org.hecl.ParseState;
import org.hecl.RealThing;
import org.hecl.StringThing;
import org.hecl.SubstThing;
import org.hecl.Thing;

public class Parse {
    protected Vector outList;
    protected ParseState state;
    protected Interp interp = null;
    protected String in;
    protected StringThing outBuf;
    protected boolean outBufNumeric = true;
    protected boolean outBufused = false;
    protected Vector outGroup;
    protected boolean parselist = false;
    private static final int DOLLAR = 0;
    private static final int COMMAND = 1;
    private static String allowed = "_/@:-";
    private static String xchars = "0123456789ABCDEFabcdef";

    public boolean more() {
        return !this.state.eof;
    }

    public Parse() {
    }

    public Parse(Interp interp_in, String in_in) {
        this.interp = interp_in;
        this.in = in_in;
        this.state = new ParseState(this.in);
    }

    public Vector parse() throws HeclException {
        this.outList = new Vector();
        this.newCurrent();
        this.state.eoc = false;
        this.parseLine(this.state);
        if (this.outList.size() > 0) {
            return this.outList;
        }
        return null;
    }

    public CodeThing parseToCode() throws HeclException {
        CodeThing code = new CodeThing();
        int i = 0;
        int cmdsize = 0;
        int beginline = 0;
        while (this.more()) {
            beginline = this.state.lineno;
            Vector cmd = this.parse();
            if (cmd == null || (cmdsize = cmd.size()) == 0) continue;
            Thing[] argv = new Thing[cmdsize];
            for (i = 0; i < cmdsize; ++i) {
                argv[i] = (Thing)cmd.elementAt(i);
            }
            code.addStanza(this.interp, argv, beginline);
        }
        return code;
    }

    protected void newCurrent() throws HeclException {
        this.outGroup = new Vector();
        this.outBufused = false;
    }

    protected void addCurrent() throws HeclException {
        if (this.outGroup.size() == 1) {
            RealThing str = (RealThing)this.outGroup.elementAt(0);
            Thing newthing = null;
            if (this.outBufNumeric) {
                String s = str.getStringRep();
                try {
                    newthing = new Thing(NumberThing.asNumber(new Thing(s)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (newthing == null) {
                newthing = new Thing(str);
            }
            this.outList.addElement(newthing.setLiteral());
        } else if (this.outGroup.size() > 1) {
            Vector<Thing> outv = new Vector<Thing>();
            Enumeration e = this.outGroup.elements();
            while (e.hasMoreElements()) {
                RealThing rt = (RealThing)e.nextElement();
                outv.addElement(new Thing(rt).setLiteral());
            }
            this.outList.addElement(GroupThing.create(outv).setLiteral());
        } else {
            this.outList.addElement(new Thing("").setLiteral());
        }
        this.newCurrent();
    }

    protected void appendToCurrent(char ch) throws HeclException {
        if (!this.outBufused) {
            this.outBuf = new StringThing();
            this.outBufNumeric = true;
            this.outBufused = true;
            this.outGroup.addElement(this.outBuf);
        }
        if (this.outBufNumeric && !Character.isDigit(ch) && ch != '.' && ch != 'E' && ch != 'e' && ch != '+' && ch != '-') {
            this.outBufNumeric = false;
        }
        this.outBuf.append(ch);
    }

    protected void addCommand() throws HeclException {
        this.addSub(1);
    }

    public void addDollar() throws HeclException {
        this.addSub(0);
    }

    public void addSub(int type) throws HeclException {
        Vector savegroup = this.outGroup;
        StringThing savebuf = this.outBuf;
        this.newCurrent();
        if (type == 0) {
            this.parseDollar(this.state);
        } else {
            this.parseCommand(this.state);
        }
        Enumeration e = this.outGroup.elements();
        while (e.hasMoreElements()) {
            RealThing rt = (RealThing)e.nextElement();
            savegroup.addElement(rt);
        }
        this.outBufused = false;
        this.outGroup = savegroup;
    }

    public void parseLine(ParseState state) throws HeclException {
        block12: while (true) {
            char ch = state.nextchar();
            if (state.done()) {
                return;
            }
            switch (ch) {
                case '\r': {
                    return;
                }
                case '\n': {
                    ++state.lineno;
                    return;
                }
                case ';': {
                    return;
                }
                case '\t': 
                case '\f': 
                case ' ': {
                    continue block12;
                }
                case '{': {
                    this.parseBlock(state);
                    break;
                }
                case '[': {
                    this.parseCommand(state);
                    break;
                }
                case '$': {
                    state.rewind();
                    this.parseWord(state);
                    break;
                }
                case '\"': {
                    this.parseText(state);
                    break;
                }
                case '\\': {
                    if (this.parseEscape(state)) continue block12;
                    this.parseWord(state);
                    break;
                }
                case '#': {
                    if (this.outList.size() == 0) {
                        this.parseComment(state);
                        return;
                    }
                }
                default: {
                    this.appendToCurrent(ch);
                    this.parseWord(state);
                }
            }
            this.addCurrent();
        }
    }

    private void parseComment(ParseState state) {
        char ch;
        do {
            if ((ch = state.nextchar()) != '\n') continue;
            ++state.lineno;
            return;
        } while (ch != '\r' && !state.done());
    }

    private static boolean isLetter(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static boolean isXDigit(char ch) {
        return xchars.indexOf(ch) >= 0;
    }

    private static boolean isValidVarPunct(char ch) {
        return allowed.indexOf(ch) >= 0;
    }

    private static boolean isXLetter(char ch) {
        return ch >= '\u00a0' && Character.isJavaIdentifierPart(ch);
    }

    private void parseDollar(ParseState state) throws HeclException {
        char ch = state.nextchar();
        if (ch == '{') {
            this.parseVarBlock(state);
        } else {
            while (Parse.isLetter(ch) || Parse.isDigit(ch) || Parse.isValidVarPunct(ch) || Parse.isXLetter(ch)) {
                this.appendToCurrent(ch);
                ch = state.nextchar();
            }
            if (!state.done()) {
                state.rewind();
            }
        }
        if (this.outGroup.size() < 1) {
            System.err.println("ERROR parsing line " + state.lineno);
        }
        this.outGroup.setElementAt(new SubstThing(this.outBuf.getStringRep()), this.outGroup.size() - 1);
    }

    protected void parseBlock(ParseState state) throws HeclException {
        this.parseBlockOrCommand(state, true, false);
    }

    protected void parseVarBlock(ParseState state) throws HeclException {
        this.parseBlockOrCommand(state, true, true);
    }

    protected void parseCommand(ParseState state) throws HeclException {
        this.parseBlockOrCommand(state, false, false);
    }

    protected void parseBlockOrCommand(ParseState state, boolean block, boolean invar) throws HeclException {
        char rdelim;
        char ldelim;
        int level = 1;
        int lastchar = 0;
        if (block) {
            ldelim = '{';
            rdelim = '}';
        } else {
            ldelim = '[';
            rdelim = ']';
        }
        while (true) {
            char ch = state.nextchar();
            if (state.done()) {
                System.err.println("ERROR parsing line " + state.lineno);
                throw new HeclException("Unbalanced " + (block ? "{}" : "[]"), "PARSE_ERROR");
            }
            if (ch == '\n') {
                ++state.lineno;
            }
            if (block || lastchar != 92) {
                if (ch == ldelim) {
                    ++level;
                } else if (ch == rdelim) {
                    --level;
                }
            }
            if (level == 0) {
                if (block || this.parselist) {
                    ch = state.nextchar();
                    if (!invar && ch != ' ' && ch != '\t' && ch != '\f' && ch != '\n' && ch != '\r' && ch != ';' && ch != '\u0000') {
                        System.err.println("ERROR parsing line " + state.lineno);
                        throw new HeclException("Extra characters after close-brace");
                    }
                    state.rewind();
                    return;
                }
                Parse hp = new Parse(this.interp, this.outBuf.getStringRep());
                CodeThing code = hp.parseToCode();
                code.marksubst = true;
                this.outGroup.setElementAt(code, this.outGroup.size() - 1);
                return;
            }
            this.appendToCurrent(ch);
            lastchar = ch;
        }
    }

    protected void parseText(ParseState state) throws HeclException {
        block6: while (true) {
            char ch = state.nextchar();
            if (state.done()) {
                return;
            }
            switch (ch) {
                case '\"': {
                    this.outBufNumeric = false;
                    return;
                }
                case '\\': {
                    this.parseEscape(state);
                    continue block6;
                }
                case '[': {
                    this.addCommand();
                    continue block6;
                }
                case '$': {
                    this.addDollar();
                    continue block6;
                }
            }
            this.appendToCurrent(ch);
        }
    }

    protected void parseWord(ParseState state) throws HeclException {
        block8: while (true) {
            char ch = state.nextchar();
            if (state.done()) {
                return;
            }
            switch (ch) {
                case '[': {
                    this.addCommand();
                    continue block8;
                }
                case '$': {
                    this.addDollar();
                    continue block8;
                }
                case '\t': 
                case '\f': 
                case ' ': {
                    return;
                }
                case '\n': {
                    ++state.lineno;
                }
                case '\r': 
                case ';': {
                    state.eoc = true;
                    return;
                }
                case '\\': {
                    if (!this.parseEscape(state)) continue block8;
                    return;
                }
            }
            this.appendToCurrent(ch);
        }
    }

    protected boolean parseEscape(ParseState state) throws HeclException {
        char ch = state.nextchar();
        if (state.done()) {
            return true;
        }
        switch (ch) {
            case '\r': {
                char ch2 = state.nextchar();
                if (ch2 == '\n') {
                    return true;
                }
                state.rewind();
            }
            case '\n': {
                return true;
            }
            case '\f': {
                this.appendToCurrent('\f');
                break;
            }
            case 'r': {
                this.appendToCurrent('\r');
                break;
            }
            case 'n': {
                this.appendToCurrent(Interp.eol[0]);
                if (Interp.eol.length <= 1) break;
                this.appendToCurrent(Interp.eol[1]);
                break;
            }
            case 't': {
                this.appendToCurrent('\t');
                break;
            }
            case 'u': {
                StringBuffer num = new StringBuffer("");
                for (int i = 0; i < 4; ++i) {
                    char nextc = state.nextchar();
                    if (state.done()) {
                        return true;
                    }
                    if (!Parse.isXDigit(nextc)) {
                        state.rewind();
                        break;
                    }
                    num.append(nextc);
                }
                try {
                    this.appendToCurrent((char)Integer.parseInt(num.toString(), 16));
                }
                catch (NumberFormatException e) {
                    System.err.println("ERROR parsing line " + state.lineno);
                    throw new HeclException("illegal unicode escape: \\u" + num);
                }
                num = null;
                break;
            }
            default: {
                this.appendToCurrent(ch);
            }
        }
        return false;
    }
}

