/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.Operator;
import org.hecl.Thing;

class ControlCmds
extends Operator {
    public static final int IF = 1;
    public static final int FOR = 2;
    public static final int FOREACH = 3;
    public static final int WHILE = 4;
    public static final int BREAK = 5;
    public static final int CONTINUE = 6;
    private static Hashtable cmdtable = new Hashtable();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Thing operate(int cmd, Interp interp, Thing[] argv) throws HeclException {
        Thing res = null;
        switch (cmd) {
            case 1: {
                res = interp.eval(argv[1]);
                if (res != null && Thing.isTrue(res)) {
                    return interp.eval(argv[2]);
                }
                if (argv.length <= 3) return null;
                int i = 3;
                while (i < argv.length) {
                    if (argv[i].toString().equals("else")) {
                        if (argv.length == i + 2) return interp.eval(argv[i + 1]);
                        throw new HeclException("malformed \"else\"");
                    }
                    if (!argv[i].toString().equals("elseif")) throw new HeclException("missing \"else/elseif\" in \"if\"");
                    if (i + 3 > argv.length) {
                        throw new HeclException("malformed \"elseif\"");
                    }
                    res = interp.eval(argv[i + 1]);
                    if (res != null && Thing.isTrue(res)) {
                        return interp.eval(argv[i + 2]);
                    }
                    i += 3;
                }
                return null;
            }
            case 2: {
                interp.eval(argv[1]);
                while (Thing.isTrue(interp.eval(argv[2]))) {
                    try {
                        interp.eval(argv[4]);
                    }
                    catch (HeclException e) {
                        if (e.code.equals("BREAK")) {
                            return null;
                        }
                        if (!e.code.equals("CONT")) throw e;
                    }
                    interp.eval(argv[3]);
                }
                return null;
            }
            case 3: {
                Vector list = ListThing.get(argv[2]);
                if (list.size() == 0) {
                    return null;
                }
                Vector varlist = ListThing.get(argv[1]);
                int i = 0;
                boolean cont = true;
                while (cont) {
                    Enumeration e = varlist.elements();
                    while (e.hasMoreElements()) {
                        if (!cont) {
                            throw new HeclException("Foreach argument list does not match list length");
                        }
                        Thing element = (Thing)list.elementAt(i);
                        element.copy = true;
                        String varname = ((Thing)e.nextElement()).toString();
                        interp.setVar(varname, element);
                        if (++i != list.size()) continue;
                        cont = false;
                    }
                    try {
                        res = interp.eval(argv[3]);
                    }
                    catch (HeclException e2) {
                        if (e2.code.equals("BREAK")) {
                            return null;
                        }
                        if (!e2.code.equals("CONT")) throw e2;
                    }
                }
                return null;
            }
            case 4: {
                break;
            }
            case 5: {
                throw new HeclException("", "BREAK");
            }
            case 6: {
                throw new HeclException("", "CONT");
            }
            default: {
                throw new HeclException("Unknown list command '" + argv[0].toString() + "' with code '" + cmd + "'.");
            }
        }
        while (Thing.isTrue(interp.eval(argv[1]))) {
            try {
                interp.eval(argv[2]);
            }
            catch (HeclException e) {
                if (e.code.equals("BREAK")) {
                    return null;
                }
                if (!e.code.equals("CONT")) throw e;
            }
        }
        return null;
    }

    public static void load(Interp ip) throws HeclException {
        Operator.load(ip, cmdtable);
    }

    public static void unload(Interp ip) throws HeclException {
        Operator.unload(ip, cmdtable);
    }

    protected ControlCmds(int cmdcode, int minargs, int maxargs) {
        super(cmdcode, minargs, maxargs);
    }

    static {
        cmdtable.put("if", new ControlCmds(1, 2, -1));
        cmdtable.put("for", new ControlCmds(2, 4, 4));
        cmdtable.put("foreach", new ControlCmds(3, 3, 3));
        cmdtable.put("while", new ControlCmds(4, 2, 2));
        cmdtable.put("break", new ControlCmds(5, 0, 0));
        cmdtable.put("continue", new ControlCmds(6, 0, 0));
    }
}

