/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.yacas;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;

public class Grapher {
    String execList;
    String token;
    int graphx = 0;
    int graphy = 0;
    int graphWidth = 10;
    int graphHeight = 10;
    int axesFontHeight = 12;
    FontMetrics fontMetrics = null;
    int exampleWidth = 48;
    public double xmin;
    public double ymin;
    public double xmax;
    public double ymax;
    String iCallList;

    public Grapher(String aCallList) {
        this.SetupCallList(aCallList);
    }

    public void SetupCallList(String aCallList) {
        this.xmin = 1.0E200;
        this.ymin = 1.0E200;
        this.xmax = -this.xmin;
        this.ymax = -this.ymin;
        this.iCallList = aCallList;
        this.RunCallList(null);
    }

    void NextToken() {
        int endPos;
        int startPos;
        for (startPos = 0; startPos < this.execList.length() && this.execList.charAt(startPos) == ' '; ++startPos) {
        }
        for (endPos = startPos; endPos < this.execList.length() && this.execList.charAt(endPos) != ' '; ++endPos) {
        }
        this.token = this.execList.substring(startPos, endPos);
        this.execList = this.execList.substring(endPos);
    }

    void DetermineBounds(double x, double y) {
        if (this.xmin > x) {
            this.xmin = x;
        }
        if (this.xmax < x) {
            this.xmax = x;
        }
        if (this.ymin > y) {
            this.ymin = y;
        }
        if (this.ymax < y) {
            this.ymax = y;
        }
    }

    int ProjectX(double x) {
        return (int)((double)this.graphx + (double)this.graphWidth * (x - this.xmin) / (this.xmax - this.xmin));
    }

    int ProjectY(double y) {
        return (int)((double)this.graphy + (double)this.graphHeight * (1.0 - (y - this.ymin) / (this.ymax - this.ymin)));
    }

    void RunCallList(Graphics g) {
        try {
            Graphics2D g2d = null;
            if (g != null && g instanceof Graphics2D) {
                g2d = (Graphics2D)g;
            }
            Color penColor = new Color(0, 0, 0);
            Color fillColor = new Color(0, 0, 0);
            if (g != null) {
                g.setColor(penColor);
            }
            this.execList = this.iCallList;
            this.NextToken();
            while (this.token.length() > 0) {
                int green;
                if (this.token.equals("lines2d")) {
                    this.NextToken();
                    int nr = Integer.parseInt(this.token);
                    this.NextToken();
                    double y2 = 0.0;
                    double x2 = Float.parseFloat(this.token);
                    this.NextToken();
                    y2 = Float.parseFloat(this.token);
                    if (g == null) {
                        this.DetermineBounds(x2, y2);
                    }
                    for (int i = 1; i < nr; ++i) {
                        double x1 = x2;
                        double y1 = y2;
                        this.NextToken();
                        x2 = Float.parseFloat(this.token);
                        this.NextToken();
                        y2 = Float.parseFloat(this.token);
                        if (g == null) {
                            this.DetermineBounds(x2, y2);
                        }
                        if (g == null) continue;
                        g.drawLine(this.ProjectX(x1), this.ProjectY(y1), this.ProjectX(x2), this.ProjectY(y2));
                    }
                } else if (this.token.equals("rectangle2d")) {
                    this.NextToken();
                    int flags = Integer.parseInt(this.token);
                    this.NextToken();
                    float x0 = Float.parseFloat(this.token);
                    this.NextToken();
                    float y0 = Float.parseFloat(this.token);
                    this.NextToken();
                    float x1 = Float.parseFloat(this.token);
                    this.NextToken();
                    float y1 = Float.parseFloat(this.token);
                    if (g == null) {
                        this.DetermineBounds(x0, y0);
                        this.DetermineBounds(x1, y1);
                    }
                    if (g != null) {
                        int swap;
                        int xPix0 = this.ProjectX(x0);
                        int yPix0 = this.ProjectY(y0);
                        int xPix1 = this.ProjectX(x1);
                        int yPix1 = this.ProjectY(y1);
                        if (xPix1 < xPix0) {
                            swap = xPix1;
                            xPix1 = xPix0;
                            xPix0 = swap;
                        }
                        if (yPix1 < yPix0) {
                            swap = yPix1;
                            yPix1 = yPix0;
                            yPix0 = swap;
                        }
                        if ((flags & 1) != 0) {
                            g.setColor(fillColor);
                            g.fillRect(xPix0, yPix0, xPix1 - xPix0, yPix1 - yPix0);
                            g.setColor(penColor);
                        }
                        if ((flags & 2) != 0) {
                            g.drawRect(xPix0, yPix0, xPix1 - xPix0, yPix1 - yPix0);
                        }
                    }
                } else if (this.token.equals("pencolor")) {
                    this.NextToken();
                    int red = Integer.parseInt(this.token);
                    this.NextToken();
                    green = Integer.parseInt(this.token);
                    this.NextToken();
                    int blue = Integer.parseInt(this.token);
                    if (g != null) {
                        penColor = new Color(red, green, blue);
                        g.setColor(penColor);
                    }
                } else if (this.token.equals("fillcolor")) {
                    this.NextToken();
                    int red = Integer.parseInt(this.token);
                    this.NextToken();
                    green = Integer.parseInt(this.token);
                    this.NextToken();
                    int blue = Integer.parseInt(this.token);
                    if (g != null) {
                        fillColor = new Color(red, green, blue);
                    }
                } else if (this.token.equals("pensize")) {
                    this.NextToken();
                    float width = Float.parseFloat(this.token);
                    if (g != null && g2d != null) {
                        g2d.setStroke(new BasicStroke(width, 1, 1));
                    }
                } else {
                    return;
                }
                this.NextToken();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void DetermineGraphBounds(int xleft, int ytop, Dimension d) {
        if (this.fontMetrics != null) {
            this.exampleWidth = this.fontMetrics.stringWidth("100000");
        }
        this.graphx = xleft + this.exampleWidth;
        this.graphy = ytop + this.axesFontHeight;
        this.graphWidth = d.width - 3 * this.exampleWidth / 2;
        this.graphHeight = d.height - 3 * this.axesFontHeight;
    }

    public void paint(Graphics g, int xleft, int ytop, Dimension d) {
        double ystart;
        Shape clip = g.getClip();
        Rectangle r = null;
        if (clip != null) {
            r = clip.getBounds();
        }
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
        }
        if (g2d != null) {
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        }
        int clipHeight = d.height;
        if (r != null && ytop + clipHeight > r.y + r.height) {
            clipHeight = r.y + r.height - ytop;
        }
        g.setClip(xleft, ytop, d.width, clipHeight);
        g.setColor(Color.white);
        g.fillRect(xleft, ytop, d.width, d.height);
        Font font = new Font("Verdana", 0, this.axesFontHeight);
        g.setFont(font);
        this.fontMetrics = g.getFontMetrics(font);
        this.DetermineGraphBounds(xleft, ytop, d);
        Color grey = new Color(164, 164, 164);
        PlotRange xRange = new PlotRange(this.xmin, this.xmax, d.width / (3 * this.exampleWidth / 2));
        int xtick = (int)(this.xmin / xRange.TickSize() - 1.0);
        if (xRange.TickSize() * (double)xtick < this.xmin) {
            ++xtick;
        }
        double xstart = xRange.TickSize() * (double)xtick;
        g.setColor(Color.black);
        for (double x = xstart; x <= this.xmax; x += xRange.TickSize()) {
            int xPix = (int)((double)this.graphx + (double)this.graphWidth * (x - this.xmin) / (this.xmax - this.xmin));
            g.setColor(grey);
            g.drawLine(xPix, this.graphy, xPix, this.graphy + this.graphHeight);
            g.setColor(Color.black);
            String num = xRange.Format(xtick);
            int numWidth = this.fontMetrics.stringWidth(num);
            g.drawString(num, xPix - numWidth / 2, this.graphy + this.graphHeight + this.fontMetrics.getAscent());
            ++xtick;
        }
        PlotRange yRange = new PlotRange(this.ymin, this.ymax, d.height / (this.axesFontHeight * 2));
        int ytick = (int)(this.ymin / yRange.TickSize() - 1.0);
        if (yRange.TickSize() * (double)ytick < this.ymin) {
            ++ytick;
        }
        for (double y = ystart = yRange.TickSize() * (double)ytick; y <= this.ymax; y += yRange.TickSize()) {
            int yPix = (int)((double)this.graphy + (double)this.graphHeight * (this.ymax - y) / (this.ymax - this.ymin));
            g.setColor(grey);
            g.drawLine(this.graphx, yPix, this.graphx + this.graphWidth, yPix);
            g.setColor(Color.black);
            String num = yRange.Format(ytick);
            int numWidth = this.fontMetrics.stringWidth(num);
            g.drawString(num, this.graphx - numWidth - 8, yPix + this.fontMetrics.getAscent() - this.axesFontHeight / 2);
            ++ytick;
        }
        int graphClipHeight = this.graphHeight;
        if (r != null && this.graphy + graphClipHeight > r.y + r.height) {
            graphClipHeight = r.y + r.height - this.graphy;
        }
        g.setClip(this.graphx, this.graphy, this.graphWidth, graphClipHeight);
        this.RunCallList(g);
        g.setClip(xleft, ytop, d.width, clipHeight);
        g.setColor(Color.black);
        if (g2d != null) {
            g2d.setStroke(new BasicStroke(3.0f, 1, 1));
        }
        g.drawRect(this.graphx, this.graphy, this.graphWidth, this.graphHeight);
        g.setClip(clip);
    }

    class PlotRange {
        double iMinValue;
        double iMaxValue;
        int iMaxSteps;
        public int iN;
        public int iStep;

        public PlotRange(double aMinValue, double aMaxValue, int aMaxSteps) {
            double tickSize;
            int nrSteps;
            this.iMinValue = aMinValue;
            this.iMaxValue = aMaxValue;
            this.iMaxSteps = aMaxSteps;
            double range = aMaxValue - aMinValue;
            this.iN = (int)(Math.log(range) / Math.log(10.0) - 1.0);
            --this.iN;
            this.iStep = 1;
            while ((nrSteps = (int)(range / (tickSize = this.TickSize()))) > aMaxSteps) {
                switch (this.iStep) {
                    case 1: {
                        this.iStep = 2;
                        break;
                    }
                    case 2: {
                        this.iStep = 5;
                        break;
                    }
                    case 5: {
                        ++this.iN;
                        this.iStep = 1;
                    }
                }
            }
        }

        public double TickSize() {
            return (double)this.iStep * Math.pow(10.0, this.iN);
        }

        public String Format(int tick) {
            String result = "";
            int fct = tick * this.iStep;
            if (this.iN >= 0 && this.iN < 3) {
                if (this.iN > 0) {
                    fct *= 10;
                }
                if (this.iN > 1) {
                    fct *= 10;
                }
                result = "" + fct;
            } else {
                int n = this.iN;
                if (fct == 10 * (fct / 10)) {
                    fct /= 10;
                    ++n;
                }
                String ex = "";
                if (n != 0 && tick != 0) {
                    ex = "e" + n;
                }
                result = "" + fct + ex;
            }
            return result;
        }
    }
}

