/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd.statics;

import java.util.ArrayList;
import java.util.Arrays;
import no.geosoft.cc.geometry.Geometry;
import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class StatMoveCmd
implements Command {
    boolean debug = false;

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        String answer;
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        ArrayList<Thing> singleargv = this.splitArgv(argv);
        int nbsingleargs = singleargv.size();
        double[] argd = new double[nbsingleargs];
        for (int i = 0; i < nbsingleargs; ++i) {
            argd[i] = NumberThing.asNumber(singleargv.get(i)).doubleValue();
        }
        switch (argd.length) {
            case 8: {
                String ystr;
                String xstr;
                double[] intersection = new double[2];
                boolean intersectionfound = false;
                double x0 = argd[0];
                double y0 = argd[1];
                double Fx = argd[2];
                double Fy = argd[3];
                double x1 = x0 + Fx;
                double y1 = y0 + Fy;
                int intersectionType = Geometry.findLineSegmentIntersection(x0, y0, x1, y1, argd[4], argd[5], argd[6], argd[7], intersection);
                switch (intersectionType) {
                    case 0: 
                    case 1: {
                        intersectionfound = true;
                        break;
                    }
                    case -1: {
                        if (this.debug) {
                            System.out.println("Kein Schnittpunkt, da Linien parallel");
                        }
                        intersection[0] = Double.POSITIVE_INFINITY;
                        intersection[1] = Double.POSITIVE_INFINITY;
                        break;
                    }
                    case -2: {
                        if (this.debug) {
                            System.out.println("Linien aufeinander liegend");
                        }
                        intersection[0] = Double.NaN;
                        intersection[1] = Double.NaN;
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (intersectionfound) {
                    xstr = StringThing.get(DoubleThing.create(intersection[0]));
                    ystr = StringThing.get(DoubleThing.create(intersection[1]));
                } else {
                    xstr = StringThing.get(DoubleThing.create(x0));
                    ystr = StringThing.get(DoubleThing.create(y0));
                }
                String Fxstr = StringThing.get(DoubleThing.create(Fx));
                String Fystr = StringThing.get(DoubleThing.create(Fy));
                answer = xstr + " " + ystr + " " + Fxstr + " " + Fystr;
                break;
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        return new Thing(answer);
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

