/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd.geom;

import java.util.ArrayList;
import java.util.Arrays;
import no.geosoft.cc.geometry.Geometry;
import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class GeomAreaCmd
implements Command {
    boolean debug = false;

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        ArrayList<Thing> singleargv = this.splitArgv(argv);
        int nbsingleargs = singleargv.size();
        double[] argd = new double[nbsingleargs];
        for (int i = 0; i < nbsingleargs; ++i) {
            argd[i] = NumberThing.asNumber(singleargv.get(i)).doubleValue();
        }
        if (argd.length < 6) {
            throw new HeclException("Illegal nb of arguments.");
        }
        if (argd.length % 2 != 0) {
            throw new HeclException("Illegal nb of arguments.");
        }
        assert (argd.length % 2 == 0) : "nb of arguments not even";
        int n = argd.length / 2;
        double[] x = new double[n];
        double[] y = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = argd[2 * i];
            y[i] = argd[1 + 2 * i];
        }
        double area = Geometry.computePolygonArea(x, y);
        area = Math.abs(area);
        String answer = StringThing.get(DoubleThing.create(area));
        return new Thing(answer);
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

