/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.bgd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class clParserBGD {
    private final boolean debug = false;
    private static final int OFFEN = -1;
    private static final int OTHER = 0;
    private static final int LINE = 1;
    private static final int POLYLINE = 2;
    private static final int CIRCLE = 4;
    private static final int POINT = 5;
    private static final int ARC = 7;
    private static final int SPHERE = 11;
    boolean FEHLER;
    private int zeilennr = 0;
    String datei;
    private static String Fehlermeldung = "";
    BufferedReader eingabe;
    private int entityname = -1;
    private double[] entity;
    double[] letzterpkt;

    public clParserBGD(String datei) {
        this.datei = datei;
        try {
            File datei_STATIKin = new File(datei);
            FileReader eingabestrom = new FileReader(datei_STATIKin);
            this.eingabe = new BufferedReader(eingabestrom);
        }
        catch (FileNotFoundException e) {
            Fehlermeldung = "Datei " + datei + " nicht vorhanden!" + '\n' + "Fehlermeldung: " + e;
            System.err.println(Fehlermeldung);
        }
    }

    public clParserBGD(BufferedReader eingabe) {
        this.eingabe = eingabe;
    }

    public boolean hasMoreElements() {
        this.FEHLER = false;
        String[] wort = this.zeileEinlesen();
        if (wort == null) {
            return false;
        }
        boolean ZEILEVORR\u00dcCKEN = true;
        boolean STEUERZEICHEN = false;
        if (wort[0].startsWith("P") || wort[0].startsWith("p")) {
            this.entityname = 5;
            STEUERZEICHEN = true;
        }
        if (wort[0].startsWith("L") || wort[0].startsWith("l")) {
            this.entityname = 1;
            STEUERZEICHEN = true;
        }
        if (wort[0].startsWith("C") || wort[0].startsWith("c") || wort[0].startsWith("K") || wort[0].startsWith("k") && !wort[0].startsWith("Kugel") && !wort[0].startsWith("KUGEL") && !wort[0].startsWith("kugel")) {
            this.entityname = 4;
            STEUERZEICHEN = true;
        }
        if (wort[0].startsWith("S") || wort[0].startsWith("s") || wort[0].startsWith("Kugel") || wort[0].startsWith("KUGEL") || wort[0].startsWith("kugel")) {
            this.entityname = 11;
            STEUERZEICHEN = true;
        }
        if (wort[0].startsWith("A") || wort[0].startsWith("a") || wort[0].startsWith("B") || wort[0].startsWith("b")) {
            this.entityname = 7;
            STEUERZEICHEN = true;
        }
        if (!STEUERZEICHEN) {
            try {
                Double.parseDouble(wort[0]);
                switch (this.entityname) {
                    case -1: {
                        this.entityname = 5;
                    }
                    case 5: {
                        ZEILEVORR\u00dcCKEN = false;
                        break;
                    }
                    case 1: {
                        ZEILEVORR\u00dcCKEN = false;
                        break;
                    }
                    default: {
                        System.out.println("Zeile " + this.zeilennr + ": Steuerzeichen erwartet. Vorgefunden: " + wort[0]);
                        this.entityname = 0;
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                this.entityname = 0;
            }
        }
        switch (this.entityname) {
            case 5: {
                if (ZEILEVORR\u00dcCKEN && (wort = this.zeileEinlesen()) == null) {
                    return false;
                }
                this.entity = this.pktParsen(wort);
                if (this.entity != null) break;
                this.FEHLER = true;
                break;
            }
            case 1: {
                int i;
                double[] neuerpkt;
                if (ZEILEVORR\u00dcCKEN) {
                    wort = this.zeileEinlesen();
                    if (wort == null) {
                        return false;
                    }
                    this.letzterpkt = this.pktParsen(wort);
                    if (this.letzterpkt == null) {
                        this.FEHLER = true;
                        break;
                    }
                    wort = this.zeileEinlesen();
                    if (wort == null) {
                        return false;
                    }
                }
                if ((neuerpkt = this.pktParsen(wort)) == null) {
                    this.FEHLER = true;
                    break;
                }
                this.entity = new double[6];
                for (i = 0; i < 3; ++i) {
                    this.entity[i] = this.letzterpkt[i];
                }
                for (i = 0; i < 3; ++i) {
                    this.entity[i + 3] = neuerpkt[i];
                }
                this.letzterpkt = neuerpkt;
                break;
            }
            case 4: 
            case 11: {
                if (ZEILEVORR\u00dcCKEN && (wort = this.zeileEinlesen()) == null) {
                    return false;
                }
                double[] neuerpkt = this.pktParsen(wort);
                if (neuerpkt == null) {
                    this.FEHLER = true;
                    break;
                }
                this.entity = new double[4];
                for (int i = 0; i < 3; ++i) {
                    this.entity[i] = neuerpkt[i];
                }
                wort = this.zeileEinlesen();
                if (wort == null) {
                    return false;
                }
                double[] werte = this.werteParsen(wort, 1);
                if (werte == null) {
                    this.FEHLER = true;
                    break;
                }
                this.entity[3] = werte[0];
                break;
            }
            case 7: {
                int i;
                if (ZEILEVORR\u00dcCKEN && (wort = this.zeileEinlesen()) == null) {
                    return false;
                }
                double[] neuerpkt = this.pktParsen(wort);
                if (neuerpkt == null) {
                    this.FEHLER = true;
                    break;
                }
                this.entity = new double[6];
                for (i = 0; i < 3; ++i) {
                    this.entity[i] = neuerpkt[i];
                }
                wort = this.zeileEinlesen();
                if (wort == null) {
                    return false;
                }
                double[] werte = this.werteParsen(wort, 3);
                if (werte == null) {
                    this.FEHLER = true;
                    break;
                }
                for (i = 0; i < 3; ++i) {
                    this.entity[i + 3] = werte[i];
                }
                break;
            }
        }
        return true;
    }

    public String getEntityName() {
        String name;
        assert (this.entityname != -1);
        switch (this.entityname) {
            case 5: {
                name = "Point";
                break;
            }
            case 1: {
                name = "Line";
                break;
            }
            case 4: {
                name = "Circle";
                break;
            }
            case 7: {
                name = "Arc";
                break;
            }
            case 11: {
                name = "Sphere";
                break;
            }
            default: {
                name = "Other";
            }
        }
        if (this.FEHLER) {
            name = "Fehler";
        }
        return name;
    }

    public double[] getEntity() {
        boolean OK;
        switch (this.entityname) {
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: {
                OK = true;
                break;
            }
            default: {
                OK = false;
            }
        }
        if (this.FEHLER) {
            OK = false;
        }
        if (OK) {
            return this.entity;
        }
        return null;
    }

    private String[] zeileEinlesen() {
        boolean LEEREZEILE;
        String zeile = "";
        String[] wort = null;
        do {
            ++this.zeilennr;
            LEEREZEILE = false;
            try {
                zeile = this.eingabe.readLine();
            }
            catch (IOException e) {
                Fehlermeldung = "Fehler in der Datei " + this.datei + ", Zeile " + this.zeilennr + '\n' + "Fehlermeldung: " + e;
                System.out.println(Fehlermeldung);
                LEEREZEILE = true;
                continue;
            }
            if (zeile == null) {
                wort = null;
                return wort;
            }
            StringTokenizer tokens = new StringTokenizer(zeile, " ,;\t");
            wort = new String[tokens.countTokens()];
            int i = 0;
            while (tokens.hasMoreTokens()) {
                wort[i] = tokens.nextToken();
                ++i;
            }
            if (wort.length == 0) {
                LEEREZEILE = true;
                continue;
            }
            if (!wort[0].startsWith("#") && !wort[0].startsWith("//") && !wort[0].startsWith("rem")) continue;
            LEEREZEILE = true;
        } while (LEEREZEILE);
        return wort;
    }

    private double[] pktParsen(String[] wort) {
        double[] pkt = new double[3];
        switch (wort.length) {
            case 3: {
                try {
                    pkt[0] = Double.parseDouble(wort[0]);
                    pkt[1] = Double.parseDouble(wort[1]);
                    pkt[2] = Double.parseDouble(wort[2]);
                    break;
                }
                catch (NumberFormatException e) {
                    System.out.println("Nicht 3 Zahlen in Zeile " + this.zeilennr + "\n Fehlermeldung: " + e.getMessage());
                    return null;
                }
            }
            case 2: {
                try {
                    pkt[0] = Double.parseDouble(wort[0]);
                    pkt[1] = 0.0;
                    pkt[2] = Double.parseDouble(wort[1]);
                    break;
                }
                catch (NumberFormatException e) {
                    System.out.println("Nicht 3 Zahlen in Zeile " + this.zeilennr + "\n Fehlermeldung: " + e.getMessage());
                    return null;
                }
            }
            default: {
                if (wort.length > 3) {
                    System.out.println("Warnung: zu viele Parameter in Zeile " + this.zeilennr);
                }
                if (wort.length < 2) {
                    System.out.println("Warnung: zu wenige Parameter in Zeile " + this.zeilennr);
                }
                return null;
            }
        }
        return pkt;
    }

    private double[] werteParsen(String[] wort, int anzahl) {
        assert (anzahl > 0);
        double[] werte = new double[anzahl];
        if (wort.length == anzahl) {
            try {
                for (int i = 0; i < anzahl; ++i) {
                    werte[i] = Double.parseDouble(wort[i]);
                }
            }
            catch (NumberFormatException e) {
                System.out.println("Nicht " + anzahl + " Zahlen in Zeile " + this.zeilennr + "\n Fehlermeldung: " + e.getMessage());
                return null;
            }
        } else {
            if (wort.length > anzahl) {
                if (wort[anzahl].startsWith("#") || wort[anzahl].startsWith("//") || wort[anzahl].startsWith("rem")) {
                    try {
                        for (int i = 0; i < anzahl; ++i) {
                            werte[i] = Double.parseDouble(wort[i]);
                        }
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Nicht " + anzahl + " Zahlen in Zeile " + this.zeilennr + "\n Fehlermeldung: " + e.getMessage());
                        return null;
                    }
                } else {
                    System.out.println("Warnung: zu viele Parameter in Zeile " + this.zeilennr);
                    return null;
                }
            }
            if (wort.length < anzahl) {
                System.out.println("Warnung: zu wenige Parameter in Zeile " + this.zeilennr);
                return null;
            }
        }
        return werte;
    }
}

