/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import net.sf.drawj2d.FreehepMode;
import net.sf.drawj2d.bgd.BgdInterpreter;
import net.sf.drawj2d.cmd.HCLparser;
import net.sf.drawj2d.inConst;
import net.sf.drawj2d.yacas.PlotDataParser;
import org.freehep.graphics2d.VectorGraphics;

class YourPanel
extends JPanel
implements inConst {
    private final Dimension dim;
    private double originX = 0.0;
    private double originY = 0.0;
    private final int srcType;
    private final String quelldatei;
    private final boolean verbose;
    FreehepMode mode;

    YourPanel(Dimension dim, FreehepMode mode, String quelldatei, double originX, double originY, boolean verbose, int srcType) {
        this.mode = mode;
        this.quelldatei = quelldatei;
        this.dim = dim;
        this.originX = originX;
        this.originY = originY;
        this.verbose = verbose;
        this.srcType = srcType;
        this.setPreferredSize(dim);
    }

    @Override
    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        VectorGraphics vg = VectorGraphics.create((Graphics)g);
        Graphics2D tempGraphics = (Graphics2D)vg.create();
        tempGraphics.setStroke(vg.getStroke());
        this.draw(tempGraphics);
        tempGraphics.dispose();
    }

    private void draw(Graphics2D g) {
        switch (this.srcType) {
            case 102: {
                g.scale(this.mode.res / 25.4, this.mode.res / 25.4);
                g.translate(this.originX, this.originY);
                BgdInterpreter bgd_interp = new BgdInterpreter(g, this.mode.width, this.mode.height);
                bgd_interp.setVerbose(this.verbose);
                this.mode.success = bgd_interp.sourceFile(this.quelldatei);
                boolean autoscale = true;
                if (!this.mode.success) break;
                bgd_interp.interpret(autoscale);
                break;
            }
            case 103: {
                PlotDataParser ypd_parser = new PlotDataParser(g, this.dim.width, this.dim.height);
                ypd_parser.setOrigin((int)Math.rint(this.originX * this.mode.res / 25.4), (int)Math.rint(this.originY * this.mode.res / 25.4));
                ypd_parser.setVerbose(this.verbose);
                this.mode.success = ypd_parser.sourceFile(this.quelldatei);
                break;
            }
            default: {
                g.scale(this.mode.res / 25.4, this.mode.res / 25.4);
                g.translate(this.originX, this.originY);
                HCLparser vg_parser = new HCLparser(g);
                vg_parser.setVerbose(this.verbose);
                this.mode.success = vg_parser.sourceFile(this.quelldatei);
            }
        }
    }
}

