/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d;

import java.awt.Graphics2D;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.drawj2d.Drawj2d;
import net.sf.drawj2d.bgd.BgdInterpreter;
import net.sf.drawj2d.cmd.HCLparser;
import net.sf.drawj2d.inConst;
import net.sf.drawj2d.yacas.PlotDataParser;
import net.sf.epsgraphics.ColorMode;
import net.sf.epsgraphics.EpsGraphics;

public class EpsgraphicsMode
implements inConst {
    private double res;
    private int pxwidth;
    private int pxheight;
    boolean success = true;
    private int type;
    private final boolean quiet;
    private final boolean verbose;
    private final String filename;
    private final String suffix;
    private final String quelldatei;
    private final double width;
    private final double height;
    private final double originX;
    private final double originY;
    private final int srcType;
    private final boolean debug = false;

    public EpsgraphicsMode(Drawj2d c) {
        this.quiet = c.quiet;
        this.verbose = c.verbose;
        this.width = c.width;
        this.height = c.height;
        this.originX = c.originX;
        this.originY = c.originY;
        this.filename = c.zieldatei;
        this.suffix = c.outputtype.toLowerCase();
        this.quelldatei = c.quelldatei;
        this.srcType = c.srcType;
        if (!this.quiet) {
            System.out.println("Mode: EpsGraphics");
        }
        this.res = 72.0;
        if (this.suffix.equals("eps") || this.suffix.equals("ps")) {
            this.type = 2;
        } else {
            System.err.println("Not supported: " + this.suffix);
            this.success = false;
        }
    }

    public void setResolution(double resolution) {
        if (!this.quiet) {
            System.out.println("Setting resolution without effect for eps");
        }
    }

    public boolean run() {
        this.pxwidth = (int)Math.rint(this.width * this.res / 25.4);
        this.pxheight = (int)Math.rint(this.height * this.res / 25.4);
        if (this.success) {
            this.writeOutput();
        }
        return this.success;
    }

    private void writeOutput() {
        assert (this.type == 2);
        FileOutputStream file = null;
        try {
            file = new FileOutputStream(this.filename);
            EpsGraphics eps = new EpsGraphics(this.filename, (OutputStream)file, 0, 0, this.pxwidth, this.pxheight, ColorMode.COLOR_RGB);
            this.draw(eps);
            eps.close();
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getLocalizedMessage());
            this.success = false;
        }
        catch (IOException ex) {
            System.err.println(ex.getLocalizedMessage());
            this.success = false;
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(EpsgraphicsMode.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.success) {
            System.out.println("Output written to: " + this.filename);
        } else {
            System.out.println("Error occurred. Check for error messages.");
        }
    }

    private void draw(EpsGraphics eps) {
        switch (this.srcType) {
            case 102: {
                eps.scale(this.res / 25.4, this.res / 25.4);
                eps.translate(this.originX, this.originY);
                BgdInterpreter bgd_interp = new BgdInterpreter((Graphics2D)eps, this.width, this.height);
                bgd_interp.setVerbose(this.verbose);
                this.success = bgd_interp.sourceFile(this.quelldatei);
                boolean autoscale = true;
                if (!this.success) break;
                bgd_interp.interpret(autoscale);
                break;
            }
            case 103: {
                PlotDataParser ypd_parser = new PlotDataParser((Graphics2D)eps, this.pxwidth, this.pxheight);
                ypd_parser.setOrigin((int)Math.rint(this.originX * this.res / 25.4), (int)Math.rint(this.originY * this.res / 25.4));
                ypd_parser.setVerbose(this.verbose);
                this.success = ypd_parser.sourceFile(this.quelldatei);
                break;
            }
            default: {
                eps.scale(this.res / 25.4, this.res / 25.4);
                eps.translate(this.originX, this.originY);
                HCLparser parser = new HCLparser((Graphics2D)eps);
                parser.setVerbose(this.verbose);
                this.success = parser.sourceFile(this.quelldatei);
            }
        }
    }
}

