/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.utils;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.View;

public class PrintMe
implements Printable {
    int currentPage = -1;
    JTextPane printPane;
    double pageEndY = 0.0;
    double pageStartY = 0.0;
    boolean scaleWidthToFit = true;
    PageFormat pFormat = new PageFormat();
    PrinterJob pJob = PrinterJob.getPrinterJob();

    protected PrintMe() {
    }

    private Document getDocument() {
        if (this.printPane != null) {
            return this.printPane.getDocument();
        }
        return null;
    }

    private boolean getScaleWidthToFit() {
        return this.scaleWidthToFit;
    }

    private void pageDialog() {
        this.pFormat = this.pJob.pageDialog(this.pFormat);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        double scale = 1.0;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.printPane.setSize((int)pageFormat.getImageableWidth(), Integer.MAX_VALUE);
        this.printPane.validate();
        View rootView = this.printPane.getUI().getRootView(this.printPane);
        if (this.scaleWidthToFit && this.printPane.getMinimumSize().getWidth() > pageFormat.getImageableWidth()) {
            scale = pageFormat.getImageableWidth() / this.printPane.getMinimumSize().getWidth();
            graphics2D.scale(scale, scale);
        }
        graphics2D.setClip((int)(pageFormat.getImageableX() / scale), (int)(pageFormat.getImageableY() / scale), (int)(pageFormat.getImageableWidth() / scale), (int)(pageFormat.getImageableHeight() / scale));
        if (pageIndex > this.currentPage) {
            this.currentPage = pageIndex;
            this.pageStartY += this.pageEndY;
            this.pageEndY = graphics2D.getClipBounds().getHeight();
        }
        graphics2D.translate(graphics2D.getClipBounds().getX(), graphics2D.getClipBounds().getY());
        Rectangle allocation = new Rectangle(0, (int)(-this.pageStartY), (int)this.printPane.getMinimumSize().getWidth(), (int)this.printPane.getPreferredSize().getHeight());
        if (this.printView(graphics2D, allocation, rootView)) {
            return 0;
        }
        this.pageStartY = 0.0;
        this.pageEndY = 0.0;
        this.currentPage = -1;
        return 1;
    }

    protected void print(JTextPane pane) {
        this.setDocument(pane);
        this.printDialog();
    }

    private void printDialog() {
        if (this.pJob.printDialog()) {
            this.pJob.setPrintable(this, this.pFormat);
            try {
                this.pJob.print();
            }
            catch (PrinterException printerException) {
                this.pageStartY = 0.0;
                this.pageEndY = 0.0;
                this.currentPage = -1;
                System.out.println("Error Printing Document");
            }
        }
    }

    private boolean printView(Graphics2D graphics2D, Shape allocation, View view) {
        boolean pageExists = false;
        Rectangle clipRectangle = graphics2D.getClipBounds();
        if (view.getViewCount() > 0) {
            for (int i = 0; i < view.getViewCount(); ++i) {
                View childView;
                Shape childAllocation = view.getChildAllocation(i, allocation);
                if (childAllocation == null || !this.printView(graphics2D, childAllocation, childView = view.getView(i))) continue;
                pageExists = true;
            }
        } else if (allocation.getBounds().getMaxY() >= clipRectangle.getY()) {
            pageExists = true;
            if (allocation.getBounds().getHeight() > clipRectangle.getHeight() && allocation.intersects(clipRectangle)) {
                view.paint(graphics2D, allocation);
            } else if (allocation.getBounds().getY() >= clipRectangle.getY()) {
                if (allocation.getBounds().getMaxY() <= clipRectangle.getMaxY()) {
                    view.paint(graphics2D, allocation);
                } else if (allocation.getBounds().getY() < this.pageEndY) {
                    this.pageEndY = allocation.getBounds().getY();
                }
            }
        }
        return pageExists;
    }

    private void setContentType(String type) {
        this.printPane.setContentType(type);
    }

    private void setDocument(JTextPane pane) {
        this.printPane = new JTextPane();
        this.setDocument(pane.getContentType(), pane.getDocument());
    }

    private void setDocument(String type, Document document) {
        this.setContentType(type);
        this.printPane.setDocument(document);
    }

    private void setScaleWidthToFit(boolean scaleWidth) {
        this.scaleWidthToFit = scaleWidth;
    }
}

