/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.utils;

import java.util.Collections;
import java.util.Vector;
import org.statcato.spreadsheet.Cell;
import org.statcato.spreadsheet.CellComparator;
import org.statcato.spreadsheet.CellComparatorDescending;
import org.statcato.utils.DataValue;
import org.statcato.utils.DataValueComparator;
import org.statcato.utils.HelperFunctions;

public class OrderingFunctions {
    public static Vector<Integer> rankColumnVector(Vector<Cell> vec, boolean ascending) {
        int i;
        Vector Cells = (Vector)vec.clone();
        if (ascending) {
            Collections.sort(Cells, new CellComparator());
        } else {
            Collections.sort(Cells, new CellComparatorDescending());
        }
        Vector<Integer> rankVector = new Vector<Integer>(Cells.size());
        for (i = 0; i < Cells.size(); ++i) {
            rankVector.addElement(null);
        }
        for (i = 0; i < Cells.size(); ++i) {
            Cell cell = (Cell)Cells.elementAt(i);
            rankVector.setElementAt(new Integer(i + 1), cell.getRow() - 1);
        }
        return rankVector;
    }

    public static Vector<Cell> sortColumnVector(Vector<Cell> vec, Vector<Cell> byVec, boolean ascending) {
        if (byVec == null) {
            Vector copy = (Vector)vec.clone();
            if (ascending) {
                Collections.sort(copy, new CellComparator());
            } else {
                Collections.sort(copy, new CellComparatorDescending());
            }
            return copy;
        }
        Vector<Cell> Cells = new Vector<Cell>();
        for (int i = 0; i < vec.size(); ++i) {
            Cells.addElement(new Cell("", i, 0));
        }
        Vector<Integer> ranks = OrderingFunctions.rankColumnVector(byVec, ascending);
        for (int i = 0; i < vec.size(); ++i) {
            Integer rank = ranks.elementAt(i);
            if (rank == null) continue;
            Cells.setElementAt(vec.elementAt(i), rank);
        }
        return Cells;
    }

    public static Vector<Vector<Cell>> sortVectors(Vector<Vector<Cell>> vecs, Vector<Boolean> orders) {
        Vector vectors = (Vector)vecs.clone();
        for (int col = vectors.size() - 1; col > 0; --col) {
            Vector<Integer> ranks = OrderingFunctions.rankColumnVector((Vector)vectors.elementAt(col), orders.elementAt(col));
            HelperFunctions.printVector(ranks);
            for (int i = 0; i < col; ++i) {
                int j;
                Vector vector = (Vector)vectors.elementAt(i);
                HelperFunctions.printVector(vector);
                Vector<Cell> vectorp = new Vector<Cell>();
                for (j = 0; j < vector.size(); ++j) {
                    vectorp.addElement(new Cell("", j + 1, 0));
                }
                for (j = 0; j < vector.size(); ++j) {
                    Integer rank = ranks.elementAt(j);
                    if (rank == null) continue;
                    vectorp.setElementAt(new Cell(((Cell)vector.elementAt(j)).toString(), rank, 0), rank - 1);
                }
                HelperFunctions.printVector(vectorp);
                vectors.setElementAt(vectorp, i);
            }
        }
        return vectors;
    }

    public static double[] rank(Vector<DataValue> data) {
        Vector sorted = (Vector)data.clone();
        Collections.sort(sorted, new DataValueComparator());
        int size = sorted.size();
        double[] ranks = new double[size];
        double rank = 1.0;
        int i = 0;
        while (i < size) {
            int j;
            int end;
            int start = i;
            for (end = i + 1; end < size && ((DataValue)sorted.elementAt(start)).getAbsoluteValue() == ((DataValue)sorted.elementAt(end)).getAbsoluteValue(); ++end) {
            }
            int sum = 0;
            for (j = start; j < end; ++j) {
                sum += j + 1;
            }
            rank = (double)sum / (double)(end - start);
            for (j = start; j < end; ++j) {
                ranks[j] = (double)((DataValue)sorted.get(j)).getSign() * rank;
            }
            i = end;
        }
        return ranks;
    }

    public static double[] rankDoubleVector(Vector<Double> data) {
        Vector sorted = (Vector)data.clone();
        Collections.sort(sorted);
        int size = sorted.size();
        double[] ranks = new double[size];
        double rank = 1.0;
        int i = 0;
        while (i < size) {
            int j;
            int end;
            int start = i;
            for (end = i + 1; end < size && ((Double)sorted.elementAt(start)).doubleValue() == ((Double)sorted.elementAt(end)).doubleValue(); ++end) {
            }
            int sum = 0;
            for (j = start; j < end; ++j) {
                sum += j + 1;
            }
            rank = (double)sum / (double)(end - start);
            for (j = start; j < end; ++j) {
                ranks[j] = rank;
            }
            i = end;
        }
        double[] ranks2 = new double[size];
        for (i = 0; i < data.size(); ++i) {
            int index = sorted.indexOf(data.elementAt(i));
            ranks2[i] = ranks[index];
        }
        return ranks2;
    }
}

