/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.utils;

import java.util.Vector;
import org.statcato.utils.HelperFunctions;

public class NumDataset {
    private Vector<String> labels = new Vector();
    private Vector<Vector<Double>> values = new Vector();

    public void add(Vector<Double> data, String label) {
        this.labels.addElement(label);
        this.values.addElement(data);
    }

    public void addDataVectorWithByVarLabels(Vector<Double> data, Vector byLabels) {
        for (int i = 0; i < byLabels.size(); ++i) {
            String label = byLabels.elementAt(i).toString();
            Double value = data.elementAt(i);
            Vector<Double> thisDataVector = this.get(label);
            if (thisDataVector == null) {
                this.labels.addElement(label);
                thisDataVector = new Vector();
                thisDataVector.addElement(value);
                this.values.addElement(thisDataVector);
                continue;
            }
            thisDataVector.addElement(value);
        }
    }

    public Vector<Double> get(String label) {
        int index = this.labels.indexOf(label);
        if (index == -1) {
            return null;
        }
        return this.values.elementAt(index);
    }

    public int size() {
        return this.labels.size();
    }

    public Vector<Vector<Double>> getValues() {
        return this.values;
    }

    public Vector<String> getLabels() {
        return this.labels;
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.labels.size(); ++i) {
            s = s + "Label = " + this.labels.elementAt(i) + "\n";
            Vector<Double> data = this.values.elementAt(i);
            s = s + "Values = " + HelperFunctions.printDoubleVectorToString(data) + "\n";
        }
        return s;
    }
}

