/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential.nonparametrics;

import java.util.Vector;
import org.statcato.statistics.NormalProbabilityDistribution;
import org.statcato.statistics.inferential.HypothesisTest;
import org.statcato.utils.HelperFunctions;
import org.statcato.utils.OrderingFunctions;

public class WilcoxonRankSumTest {
    private int n1;
    private int n2;
    private double rankSum1;
    private double rankSum2;
    private int testType;
    public double significance;

    public WilcoxonRankSumTest(Vector<Double> data1, Vector<Double> data2, int testType, double significance) {
        this.testType = testType;
        this.significance = significance;
        this.n1 = data1.size();
        this.n2 = data2.size();
        this.rankSum1 = this.getRankSum(data1, data2);
        this.rankSum2 = (double)((this.n1 + this.n2) * (this.n1 + this.n2 + 1) / 2) - this.rankSum1;
    }

    public double testStatistic_R() {
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return (this.rankSum1 - this.mu_R() + 0.5) / this.sigma_R();
        }
        return (this.rankSum1 - this.mu_R() - 0.5) / this.sigma_R();
    }

    public double mu_R() {
        return (double)(this.n1 * (this.n1 + this.n2 + 1)) / 2.0;
    }

    public double sigma_R() {
        return Math.sqrt(this.n1 * this.n2 * (this.n1 + this.n2 + 1) / 12);
    }

    public double pValue_R() {
        NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
        double p = dist.cumulativeProbability(this.testStatistic_R());
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return p;
        }
        if (this.testType == HypothesisTest.RIGHT_TAIL) {
            return 1.0 - p;
        }
        return 2.0 * (p <= 0.5 ? p : 1.0 - p);
    }

    public double criticalValue_R() {
        NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
        if (this.testType == HypothesisTest.RIGHT_TAIL) {
            return dist.inverseCumulativeProbability(1.0 - this.significance);
        }
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return dist.inverseCumulativeProbability(this.significance);
        }
        return Math.abs(dist.inverseCumulativeProbability(this.significance / 2.0));
    }

    public String toString() {
        String s = "";
        s = s + "Wilcoxon Rank Sum Test: <br>";
        s = s + "<table border='1'>";
        s = s + "<tr>";
        s = s + "<th>n<sub>1</sub></th><th>n<sub>2</sub></th><th>R<sub>1</sub></th><th>R<sub>2</sub></th>";
        s = s + "<th>&mu;<sub>R</sub></th><th>&sigma;<sub>R</sub></th>";
        s = s + "<th>Test Statistics z<sub>R</sub></th><th>Critical Value</th><th>p-Value</th>";
        s = s + "</tr>";
        s = s + "<td>" + this.n1 + "</td>";
        s = s + "<td>" + this.n2 + "</td>";
        s = s + "<td>" + this.rankSum1 + "</td>";
        s = s + "<td>" + this.rankSum2 + "</td>";
        s = s + "<td>" + HelperFunctions.formatFloat(this.mu_R(), 3) + "</td>";
        s = s + "<td>" + HelperFunctions.formatFloat(this.sigma_R(), 3) + "</td>";
        s = s + "<td>" + HelperFunctions.formatFloat(this.testStatistic_R(), 3) + "</td>";
        s = s + "<td>" + (this.testType == HypothesisTest.TWO_TAIL ? "&plusmn;" : "") + HelperFunctions.formatFloat(this.criticalValue_R(), 3) + "</td>";
        s = s + "<td>" + HelperFunctions.formatFloat(this.pValue_R(), 5) + "</td>";
        s = s + "</tr>";
        s = s + "</table><br>";
        return s;
    }

    public double getRankSum(Vector<Double> data1, Vector<Double> data2) {
        Vector<Double> dataVector = new Vector<Double>();
        for (Double next : data1) {
            if (next == null) continue;
            dataVector.add(next);
        }
        for (Double next : data2) {
            if (next == null) continue;
            dataVector.add(next);
        }
        double[] ranks = OrderingFunctions.rankDoubleVector(dataVector);
        double rankSum = 0.0;
        for (int i = 0; i < data1.size(); ++i) {
            Double next = data1.elementAt(i);
            if (next == null) continue;
            rankSum += ranks[dataVector.indexOf(next)];
        }
        return rankSum;
    }
}

