/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential.nonparametrics;

import java.util.Vector;
import org.statcato.statistics.BasicStatistics;
import org.statcato.statistics.BinomialProbabilityDistribution;
import org.statcato.statistics.NormalProbabilityDistribution;
import org.statcato.utils.HelperFunctions;

public class SignTest {
    private int sampleSize;
    private int numPositive;
    private int numNegative;
    private double testMedian;
    private double sampleMedian;
    private int testType;
    public static int LESS = 0;
    public static int GREATER = 2;
    public static int NOTEQUAL = 1;
    public static int THRESHOLD = 50;

    public SignTest(int numPositive, int numNegative, double testMedian, int testType) {
        this.numPositive = numPositive;
        this.numNegative = numNegative;
        this.testMedian = testMedian;
        this.testType = testType;
        this.sampleSize = numPositive + numNegative;
        this.sampleMedian = Double.NaN;
    }

    public SignTest(Vector<Double> data, double testMedian, int testType) {
        this.testMedian = testMedian;
        this.testType = testType;
        this.numPositive = BasicStatistics.numberOfPositiveSigns(data, testMedian);
        this.numNegative = BasicStatistics.numberOfNegativeSigns(data, testMedian);
        this.sampleSize = this.numPositive + this.numNegative;
        this.sampleMedian = BasicStatistics.median(data);
    }

    public double pValue() {
        double s;
        if (this.sampleSize <= THRESHOLD) {
            BinomialProbabilityDistribution dist = new BinomialProbabilityDistribution(this.numPositive + this.numNegative, 0.5);
            if (this.testType == LESS) {
                return dist.cumulativeProbability(this.numPositive);
            }
            if (this.testType == GREATER) {
                return dist.cumulativeProbability(this.numNegative);
            }
            int[] nArray = new int[]{this.numPositive, this.numNegative};
            int[] nums = nArray;
            double area = dist.cumulativeProbability(BasicStatistics.min(nums));
            if (area > 0.5) {
                area = 1.0 - area;
            }
            return 2.0 * area;
        }
        int n = this.numPositive + this.numNegative;
        NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
        if (this.testType == LESS) {
            s = this.numPositive;
        } else if (this.testType == GREATER) {
            s = this.numNegative;
        } else {
            int[] nums = new int[]{this.numPositive, this.numNegative};
            s = BasicStatistics.min(nums);
        }
        s = (s + 0.5 - (double)(n / 2)) / (Math.sqrt(n) / 2.0);
        double p = dist.cumulativeProbability(s);
        if (this.testType == LESS || this.testType == GREATER) {
            return p;
        }
        return 2.0 * p;
    }

    public String toString() {
        String s = "";
        s = s + "Sign Test: <br>";
        if (this.numPositive + this.numNegative > 50) {
            s = s + "Using normal approximation<br>";
        }
        s = s + "<table border='1'>";
        s = s + "<tr>";
        s = s + "<th>Sample size</th><th># Negatives</th><th># Positives</th>";
        s = s + "<th>Sample Median</th><th>p-Value</th>";
        s = s + "</tr>";
        s = s + "<td>" + this.sampleSize + "</td>";
        s = s + "<td>" + this.numNegative + "</td>";
        s = s + "<td>" + this.numPositive + "</td>";
        s = s + "<td>";
        s = Double.isNaN(this.sampleMedian) ? s + "NA" : s + HelperFunctions.formatFloat(this.sampleMedian, 5);
        s = s + "</td>";
        s = s + "<td>" + HelperFunctions.formatFloat(this.pValue(), 5) + "</td>";
        s = s + "</tr>";
        s = s + "</table>";
        return s;
    }
}

