/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import org.statcato.statistics.FProbabilityDistribution;
import org.statcato.statistics.inferential.TwoANOVATableCell;
import org.statcato.utils.HelperFunctions;

public class TwoWayANOVA {
    private int a;
    private int b;
    private int N;
    private int n;
    private double CM;
    private TwoANOVATableCell[][] y;

    public TwoWayANOVA(int a, int b) {
        this.a = a;
        this.b = b;
        this.y = new TwoANOVATableCell[a][b];
        for (int i = 0; i < a; ++i) {
            for (int j = 0; j < b; ++j) {
                this.y[i][j] = new TwoANOVATableCell();
            }
        }
    }

    public void addObservation(int i, int j, double data) {
        this.y[i][j].addObservation(data);
    }

    public boolean isValidData() {
        int size = this.y[0][0].getSize();
        for (int i = 0; i < this.a; ++i) {
            for (int j = 0; j < this.b; ++j) {
                if (this.y[i][j].getSize() == size) continue;
                return false;
            }
        }
        this.n = size;
        this.N = this.a * this.b * this.n;
        this.findCM();
        return true;
    }

    public double rowSum(int i) {
        double sum = 0.0;
        for (int j = 0; j < this.b; ++j) {
            sum += this.y[i][j].sum();
        }
        return sum;
    }

    public double colSum(int j) {
        double sum = 0.0;
        for (int i = 0; i < this.a; ++i) {
            sum += this.y[i][j].sum();
        }
        return sum;
    }

    public void findCM() {
        double sum = 0.0;
        for (int i = 0; i < this.a; ++i) {
            for (int j = 0; j < this.b; ++j) {
                sum += this.y[i][j].sum();
            }
        }
        this.CM = sum * sum / (double)this.N;
    }

    public double SSA() {
        double sum = 0.0;
        for (int i = 0; i < this.a; ++i) {
            sum += Math.pow(this.rowSum(i), 2.0);
        }
        return sum / (double)(this.b * this.n) - this.CM;
    }

    public double SSB() {
        double sum = 0.0;
        for (int j = 0; j < this.b; ++j) {
            sum += Math.pow(this.colSum(j), 2.0);
        }
        return sum / (double)(this.a * this.n) - this.CM;
    }

    public double SSAB() {
        if (this.n == 1) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < this.a; ++i) {
            for (int j = 0; j < this.b; ++j) {
                sum += Math.pow(this.y[i][j].sum(), 2.0);
            }
        }
        return sum / (double)this.n - this.CM - this.SSA() - this.SSB();
    }

    public double SSTotal() {
        double sum = 0.0;
        for (int i = 0; i < this.a; ++i) {
            for (int j = 0; j < this.b; ++j) {
                sum += this.y[i][j].sumOfSquares();
            }
        }
        return sum - this.CM;
    }

    public double SSE() {
        return this.SSTotal() - this.SSA() - this.SSB() - this.SSAB();
    }

    public double MSA() {
        return this.SSA() / (double)this.DOFA();
    }

    public double MSB() {
        return this.SSB() / (double)this.DOFB();
    }

    public double MSAB() {
        return this.SSAB() / (double)this.DOFAB();
    }

    public double MSE() {
        return this.SSE() / (double)this.DOFE();
    }

    public int DOFA() {
        return this.a - 1;
    }

    public int DOFB() {
        return this.b - 1;
    }

    public int DOFAB() {
        return (this.a - 1) * (this.b - 1);
    }

    public int DOFE() {
        if (this.n == 1) {
            return this.N - 1 - (this.a - 1) - (this.b - 1);
        }
        return this.N - this.a * this.b;
    }

    public int DOFTotal() {
        return this.a * this.b * this.n - 1;
    }

    public double FA() {
        return this.MSA() / this.MSE();
    }

    public double FB() {
        return this.MSB() / this.MSE();
    }

    public double FAB() {
        return this.MSAB() / this.MSE();
    }

    public double PValueA() {
        double ts = this.FA();
        FProbabilityDistribution dist = new FProbabilityDistribution(this.DOFA(), this.DOFE());
        double area = dist.cumulativeProbability(ts);
        return 1.0 - area;
    }

    public double PValueB() {
        double ts = this.FB();
        FProbabilityDistribution dist = new FProbabilityDistribution(this.DOFB(), this.DOFE());
        double area = dist.cumulativeProbability(ts);
        return 1.0 - area;
    }

    public double PValueAB() {
        double ts = this.FAB();
        FProbabilityDistribution dist = new FProbabilityDistribution(this.DOFAB(), this.DOFE());
        double area = dist.cumulativeProbability(ts);
        return 1.0 - area;
    }

    public String toString() {
        String text = "Treatment group size = " + this.n + "<br>";
        text = text + "Total sample size = " + this.N + "<br>";
        text = text + "<table border='1'>";
        text = text + "<tr align='right'><th>Source of Variation</th><th>DOF</th><th>SS</th><th>MS</th><th>F</th><th>p-Value</th></tr>";
        text = text + "<tr align='right'><th>Row Factor</th><td>" + this.DOFA() + "</td>" + "<td>" + HelperFunctions.formatFloat(this.SSA(), 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(this.MSA(), 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(this.FA(), 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(this.PValueA(), 5) + "</td></tr>";
        text = text + "<tr align='right'><th>Column Factor</th><td>" + this.DOFB() + "</td>" + "<td>" + HelperFunctions.formatFloat(this.SSB(), 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(this.MSB(), 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(this.FB(), 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(this.PValueB(), 5) + "</td></tr>";
        if (this.n > 1) {
            text = text + "<tr align='right'><th>Interaction</th><td>" + this.DOFAB() + "</td>" + "<td>" + HelperFunctions.formatFloat(this.SSAB(), 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(this.MSAB(), 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(this.FAB(), 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(this.PValueAB(), 5) + "</td></tr>";
        }
        text = text + "<tr align='right'><th>Error</th><td>" + this.DOFE() + "</td>" + "<td>" + HelperFunctions.formatFloat(this.SSE(), 5) + "</td>" + "<td>" + HelperFunctions.formatFloat(this.MSE(), 5) + "</td>" + "<td>&nbsp;</td><td>&nbsp;</td></tr>";
        text = text + "<tr align='right'><th>Total</th><td>" + this.DOFTotal() + "</td>" + "<td>" + HelperFunctions.formatFloat(this.SSTotal(), 5) + "</td>" + "<td>&nbsp;</td>" + "<td>&nbsp;</td><td>&nbsp;</td></tr>";
        text = text + "</table>";
        return text;
    }
}

