/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import org.statcato.statistics.FProbabilityDistribution;
import org.statcato.statistics.inferential.HypothesisTest;
import org.statcato.utils.HelperFunctions;

public class HypothesisTest2Var {
    int n1;
    int n2;
    double var1;
    double var2;
    double confidenceLevel;
    int testType;

    public HypothesisTest2Var(int n1, int n2, double var1, double var2, double confidenceLevel, int testType) {
        this.n1 = n1;
        this.n2 = n2;
        this.var1 = var1;
        this.var2 = var2;
        this.confidenceLevel = confidenceLevel;
        this.testType = testType;
    }

    public double testStatistics() {
        return this.var1 / this.var2;
    }

    public int DOF1() {
        return this.n1 - 1;
    }

    public int DOF2() {
        return this.n2 - 1;
    }

    public String criticalValue() {
        double alpha = 1.0 - this.confidenceLevel;
        FProbabilityDistribution dist = new FProbabilityDistribution(this.DOF1(), this.DOF2());
        if (this.testType == HypothesisTest.RIGHT_TAIL) {
            return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(1.0 - alpha), 3);
        }
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(alpha), 3);
        }
        return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(alpha / 2.0), 3) + ", " + HelperFunctions.formatFloat(dist.inverseCumulativeProbability(1.0 - alpha / 2.0), 3);
    }

    public double pValue() {
        double ts = this.testStatistics();
        FProbabilityDistribution dist = new FProbabilityDistribution(this.DOF1(), this.DOF2());
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return dist.cumulativeProbability(ts);
        }
        if (this.testType == HypothesisTest.RIGHT_TAIL) {
            return 1.0 - dist.cumulativeProbability(ts);
        }
        double area = dist.cumulativeProbability(ts);
        if (area > 0.5) {
            area = 1.0 - area;
        }
        return 2.0 * area;
    }
}

