/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import org.statcato.statistics.StudentTProbabilityDistribution;
import org.statcato.statistics.inferential.HypothesisTest;
import org.statcato.utils.HelperFunctions;

public class HypothesisTest2MeanSigmaUnknown {
    int n1;
    int n2;
    double xBar1;
    double xBar2;
    double s1;
    double s2;
    double diff;
    double confidenceLevel;
    int testType;
    boolean varEqual;

    public HypothesisTest2MeanSigmaUnknown(int n1, int n2, double xBar1, double xBar2, double s1, double s2, double diff, double confidenceLevel, int testType, boolean varEqual) {
        this.n1 = n1;
        this.n2 = n2;
        this.xBar1 = xBar1;
        this.xBar2 = xBar2;
        this.s1 = s1;
        this.s2 = s2;
        this.diff = diff;
        this.confidenceLevel = confidenceLevel;
        this.testType = testType;
        this.varEqual = varEqual;
    }

    public double testStatistics() {
        if (this.varEqual) {
            double sp2 = (((double)this.n1 - 1.0) * this.s1 * this.s1 + ((double)this.n2 - 1.0) * this.s2 * this.s2) / ((double)(this.n1 + this.n2) - 2.0);
            return (this.xBar1 - this.xBar2 - this.diff) / Math.sqrt(sp2 / (double)this.n1 + sp2 / (double)this.n2);
        }
        return (this.xBar1 - this.xBar2 - this.diff) / Math.sqrt(this.s1 * this.s1 / (double)this.n1 + this.s2 * this.s2 / (double)this.n2);
    }

    public int DOF() {
        if (this.varEqual) {
            return this.n1 + this.n2 - 2;
        }
        double A = this.s1 * this.s1 / (double)this.n1;
        double B = this.s2 * this.s2 / (double)this.n2;
        return (int)Math.floor(Math.pow(A + B, 2.0) / (A * A / (double)(this.n1 - 1) + B * B / (double)(this.n2 - 1)));
    }

    public String criticalValue() {
        double alpha = 1.0 - this.confidenceLevel;
        StudentTProbabilityDistribution dist = new StudentTProbabilityDistribution(this.DOF());
        if (this.testType == HypothesisTest.RIGHT_TAIL) {
            return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(1.0 - alpha), 3);
        }
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(alpha), 3);
        }
        return HelperFunctions.formatFloat(dist.inverseCumulativeProbability(alpha / 2.0), 3) + ", " + HelperFunctions.formatFloat(dist.inverseCumulativeProbability(1.0 - alpha / 2.0), 3);
    }

    public double pValue() {
        double ts = this.testStatistics();
        StudentTProbabilityDistribution dist = new StudentTProbabilityDistribution(this.DOF());
        if (this.testType == HypothesisTest.LEFT_TAIL) {
            return dist.cumulativeProbability(ts);
        }
        if (this.testType == HypothesisTest.RIGHT_TAIL) {
            return 1.0 - dist.cumulativeProbability(ts);
        }
        double area = dist.cumulativeProbability(ts);
        if (area > 0.5) {
            area = 1.0 - area;
        }
        return 2.0 * area;
    }
}

