/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import java.util.Vector;
import org.statcato.statistics.inferential.ContingencyTable;

public class CrossTabulation {
    private int a;
    private int b;
    private double[][] y;
    private ContingencyTable contingencyTable;

    public CrossTabulation(int a, int b) {
        this.a = a;
        this.b = b;
        this.y = new double[a][b];
        for (int i = 0; i < a; ++i) {
            for (int j = 0; j < b; ++j) {
                this.y[i][j] = 0.0;
            }
        }
    }

    public void addObservation(int i, int j, double frequency) {
        double[] dArray = this.y[i];
        int n = j;
        dArray[n] = dArray[n] + frequency;
    }

    public double getFrequency(int i, int j) {
        return this.y[i][j];
    }

    public double getPercent(int i, int j) {
        return this.getFrequency(i, j) / this.getTotalSum();
    }

    public double getRowSum(int i) {
        double sum = 0.0;
        for (int j = 0; j < this.b; ++j) {
            sum += this.y[i][j];
        }
        return sum;
    }

    public double getRowSumPercent(int i) {
        return this.getRowSum(i) / this.getTotalSum();
    }

    public double getColumnSum(int j) {
        double sum = 0.0;
        for (int i = 0; i < this.a; ++i) {
            sum += this.y[i][j];
        }
        return sum;
    }

    public double getColumnSumPercent(int i) {
        return this.getColumnSum(i) / this.getTotalSum();
    }

    public double getTotalSum() {
        double sum = 0.0;
        for (int i = 0; i < this.a; ++i) {
            for (int j = 0; j < this.b; ++j) {
                sum += this.y[i][j];
            }
        }
        return sum;
    }

    public void computeChiSquare() {
        Vector<Vector<Double>> table = new Vector<Vector<Double>>();
        for (int j = 0; j < this.b; ++j) {
            Vector<Double> vec = new Vector<Double>();
            for (int i = 0; i < this.a; ++i) {
                vec.addElement(new Double(this.y[i][j]));
            }
            table.addElement(vec);
        }
        this.contingencyTable = new ContingencyTable(table);
    }

    public ContingencyTable getContingencyTable() {
        return this.contingencyTable;
    }
}

