/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import org.statcato.statistics.ChiSquareProbabilityDistribution;
import org.statcato.utils.HelperFunctions;

public class CIOnePopVar {
    private double variance;
    private int n;
    private double confidenceLevel;

    public CIOnePopVar(double confidenceLevel, int n, double variance) {
        this.n = n;
        this.variance = variance;
        this.confidenceLevel = confidenceLevel;
    }

    public double lowerLimit() {
        double alpha = 1.0 - this.confidenceLevel;
        ChiSquareProbabilityDistribution dist = new ChiSquareProbabilityDistribution(this.n - 1);
        double XR2 = dist.inverseCumulativeProbability(1.0 - alpha / 2.0);
        return (double)(this.n - 1) * this.variance / XR2;
    }

    public double upperLimit() {
        double alpha = 1.0 - this.confidenceLevel;
        ChiSquareProbabilityDistribution dist = new ChiSquareProbabilityDistribution(this.n - 1);
        double XL2 = dist.inverseCumulativeProbability(alpha / 2.0);
        return (double)(this.n - 1) * this.variance / XL2;
    }

    public String toString() {
        return "(" + HelperFunctions.formatFloat(this.lowerLimit(), 4) + ", " + HelperFunctions.formatFloat(this.upperLimit(), 4) + ")";
    }

    public String stdevCI() {
        return "(" + HelperFunctions.formatFloat(Math.sqrt(this.lowerLimit()), 4) + ", " + HelperFunctions.formatFloat(Math.sqrt(this.upperLimit()), 4) + ")";
    }
}

