/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import org.statcato.statistics.StudentTProbabilityDistribution;
import org.statcato.statistics.inferential.ConfidenceInterval;

public class CIOnePopMeanSigmaUnknown
extends ConfidenceInterval {
    private double s;
    private int n;

    public CIOnePopMeanSigmaUnknown(double confidenceLevel, int n, double mean, double s) {
        this.n = n;
        this.s = s;
        this.center = mean;
        this.confidenceLevel = confidenceLevel;
    }

    @Override
    public double marginOfError() {
        return this.criticalValue() * this.s / Math.sqrt(this.n);
    }

    @Override
    public double criticalValue() {
        double alpha = 1.0 - this.confidenceLevel;
        StudentTProbabilityDistribution dist = new StudentTProbabilityDistribution(this.n - 1);
        return dist.inverseCumulativeProbability(1.0 - alpha / 2.0);
    }

    public double getStdev() {
        return this.s;
    }

    public double getN() {
        return this.n;
    }
}

