/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import org.statcato.statistics.FProbabilityDistribution;
import org.statcato.utils.HelperFunctions;

public class CI2PopVar {
    private double var1;
    private double var2;
    private int n1;
    private int n2;
    private double confidenceLevel;

    public CI2PopVar(double confidenceLevel, int n1, int n2, double var1, double var2) {
        this.n1 = n1;
        this.n2 = n2;
        this.var1 = var1;
        this.var2 = var2;
        this.confidenceLevel = confidenceLevel;
    }

    public double criticalValueRight() {
        double alpha = 1.0 - this.confidenceLevel;
        FProbabilityDistribution dist = new FProbabilityDistribution(this.n1 - 1, this.n2 - 1);
        return dist.inverseCumulativeProbability(1.0 - alpha / 2.0);
    }

    public double criticalValueLeft() {
        double alpha = 1.0 - this.confidenceLevel;
        FProbabilityDistribution dist = new FProbabilityDistribution(this.n1 - 1, this.n2 - 1);
        return dist.inverseCumulativeProbability(alpha / 2.0);
    }

    public double lowerLimit() {
        return this.var1 / this.var2 / this.criticalValueRight();
    }

    public double upperLimit() {
        return this.var1 / this.var2 / this.criticalValueLeft();
    }

    public String CIVar() {
        return "(" + HelperFunctions.formatFloat(this.lowerLimit(), 4) + ", " + HelperFunctions.formatFloat(this.upperLimit(), 4) + ")";
    }

    public String CIStdev() {
        return "(" + HelperFunctions.formatFloat(Math.sqrt(this.lowerLimit()), 4) + ", " + HelperFunctions.formatFloat(Math.sqrt(this.upperLimit()), 4) + ")";
    }
}

