/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import org.statcato.statistics.NormalProbabilityDistribution;
import org.statcato.statistics.inferential.ConfidenceInterval;

public class CI2PopProp
extends ConfidenceInterval {
    private double p1;
    private double p2;
    private int n1;
    private int n2;

    public CI2PopProp(double confidenceLevel, int n1, int n2, double p1, double p2) {
        this.n1 = n1;
        this.n2 = n2;
        this.p1 = p1;
        this.p2 = p2;
        this.center = p1 - p2;
        this.confidenceLevel = confidenceLevel;
    }

    @Override
    public double marginOfError() {
        return this.criticalValue() * Math.sqrt(this.p1 * (1.0 - this.p1) / (double)this.n1 + this.p2 * (1.0 - this.p2) / (double)this.n2);
    }

    @Override
    public double criticalValue() {
        double alpha = 1.0 - this.confidenceLevel;
        NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
        return dist.inverseCumulativeProbability(1.0 - alpha / 2.0);
    }
}

