/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics.inferential;

import org.statcato.statistics.StudentTProbabilityDistribution;
import org.statcato.statistics.inferential.ConfidenceInterval;

public class CI2PopMeanSigmaUnknown
extends ConfidenceInterval {
    private double s1;
    private double s2;
    private int n1;
    private int n2;
    private double xBar1;
    private double xBar2;
    private boolean varEqual;

    public CI2PopMeanSigmaUnknown(double confidenceLevel, int n1, int n2, double xBar1, double xBar2, double s1, double s2, boolean varEqual) {
        this.n1 = n1;
        this.n2 = n2;
        this.s1 = s1;
        this.s2 = s2;
        this.xBar1 = xBar1;
        this.xBar2 = xBar2;
        this.center = xBar1 - xBar2;
        this.confidenceLevel = confidenceLevel;
        this.varEqual = varEqual;
    }

    @Override
    public double marginOfError() {
        if (this.varEqual) {
            double sp2 = (((double)this.n1 - 1.0) * this.s1 * this.s1 + ((double)this.n2 - 1.0) * this.s2 * this.s2) / ((double)(this.n1 + this.n2) - 2.0);
            return this.criticalValue() * Math.sqrt(sp2 * (1.0 / (double)this.n1 + 1.0 / (double)this.n2));
        }
        return this.criticalValue() * Math.sqrt(this.s1 * this.s1 / (double)this.n1 + this.s2 * this.s2 / (double)this.n2);
    }

    @Override
    public double criticalValue() {
        double alpha = 1.0 - this.confidenceLevel;
        StudentTProbabilityDistribution dist = new StudentTProbabilityDistribution(this.DOF());
        return dist.inverseCumulativeProbability(1.0 - alpha / 2.0);
    }

    public int DOF() {
        if (this.varEqual) {
            return this.n1 + this.n2 - 2;
        }
        double A = this.s1 * this.s1 / (double)this.n1;
        double B = this.s2 * this.s2 / (double)this.n2;
        return (int)Math.floor(Math.pow(A + B, 2.0) / (A * A / (double)(this.n1 - 1) + B * B / (double)(this.n2 - 1)));
    }
}

