/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics;

import org.statcato.statistics.ProbabilityDistribution;

public class UniformProbabilityDistribution
extends ProbabilityDistribution {
    double lower;
    double upper;
    double uniformDensity;

    public UniformProbabilityDistribution(double lower, double upper) {
        this.lower = lower;
        this.upper = upper;
        this.uniformDensity = 1.0 / (upper - lower);
    }

    @Override
    public double density(double x) {
        if (x < this.lower || x > this.upper) {
            return 0.0;
        }
        return this.uniformDensity;
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= this.lower) {
            return 0.0;
        }
        if (x >= this.upper) {
            return 1.0;
        }
        return this.uniformDensity * (x - this.lower);
    }

    public double inverseCumulativeProbability(double area) {
        return area / this.uniformDensity + this.lower;
    }
}

