/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics;

import org.statcato.statistics.DiscreteProbabilityDistribution;
import org.statcato.statistics.SpecialFunctions;

public class PoissonProbabilityDistribution
extends DiscreteProbabilityDistribution {
    double lambda;

    public PoissonProbabilityDistribution(double lambda) {
        this.lambda = lambda;
    }

    @Override
    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        double ee = x * Math.log(this.lambda) - this.lambda - SpecialFunctions.gammln(x + 1.0);
        return Math.exp(ee);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return SpecialFunctions.gammq(x + 1.0, this.lambda);
    }

    public Double inverseCumulativeProbability(double area) {
        return super.inverseCumulativeProbability(0.0, 20.0 * this.lambda, 1.0E-4, area);
    }
}

