/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics;

import java.util.Collections;
import java.util.Vector;
import org.statcato.statistics.BasicStatistics;
import org.statcato.statistics.NormalProbabilityDistribution;
import org.statcato.statistics.inferential.CorrelationRegression;
import org.statcato.utils.HelperFunctions;

public class NormalityTest {
    Vector<Double> dataVector;
    Vector<Double> zscoresVector;
    double significance;
    int n;

    public NormalityTest(Vector<Double> data, double sig) {
        this.dataVector = data;
        this.significance = sig;
        this.zscoresVector = new Vector();
        Collections.sort(this.dataVector);
        this.n = this.dataVector.size();
        for (int i = 0; i < this.n; ++i) {
            double a = ((double)i + 1.0) / ((double)this.n + 1.0);
            NormalProbabilityDistribution dist = new NormalProbabilityDistribution(0.0, 1.0);
            double z = dist.inverseCumulativeProbability(a);
            this.zscoresVector.addElement(new Double(z));
        }
    }

    public String toString() {
        String text = "";
        text = text + "<u>Normality Test (Ryan-Joiner):</u><br>";
        CorrelationRegression c = new CorrelationRegression(this.dataVector, this.zscoresVector, this.significance);
        text = text + "&nbsp;&nbsp;Sample Size: n = " + this.n + "<br>";
        text = text + "&nbsp;&nbsp;Significance: " + this.significance + "<br>";
        text = text + "&nbsp;&nbsp;Correlation Coefficient: r = " + HelperFunctions.formatFloat(c.LinearCorrelationCoeff(), 5) + "<br>";
        text = text + "&nbsp;&nbsp;Critical Value: " + HelperFunctions.formatFloat(BasicStatistics.RyanJoinerNormalityCV(this.n, this.significance), 5);
        if (this.n > 75) {
            text = text + "<br><i>Warning</i>: large sample size n > 75";
        }
        return text;
    }
}

