/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics;

public class IntegerProbabilityDistribution {
    int min;
    int max;
    double p;

    public IntegerProbabilityDistribution(int min, int max) {
        this.min = min;
        this.max = max;
        this.p = 1.0 / (double)(max - min + 1);
    }

    public double density(double x) {
        if (x >= (double)this.min && x <= (double)this.max) {
            return this.p;
        }
        return 0.0;
    }

    public double cumulativeProbability(double x) {
        if (x < (double)this.min) {
            return 0.0;
        }
        if (x >= (double)this.max) {
            return 1.0;
        }
        return (Math.floor(x) - (double)this.min + 1.0) * this.p;
    }

    public Integer inverseCumulativeProbability(double area) {
        if (area < 0.0 || area > 1.0) {
            return null;
        }
        if (area == 1.0) {
            return new Integer(this.max);
        }
        if (area == 0.0) {
            return new Integer(this.min);
        }
        int i = (int)Math.round(area / this.p);
        if (i < 1) {
            return new Integer(this.min);
        }
        return new Integer(i + this.min - 1);
    }
}

