/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics;

import org.statcato.statistics.ProbabilityDistribution;

public class ExponentialProbabilityDistribution
extends ProbabilityDistribution {
    private double lambda;

    public ExponentialProbabilityDistribution(double lambda) {
        this.lambda = lambda;
    }

    @Override
    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return this.lambda * Math.exp(-this.lambda * x);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-this.lambda * x);
    }

    public double inverseCumulativeProbability(double area) {
        return Math.log(1.0 - area) / -this.lambda;
    }
}

