/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.statistics;

import org.statcato.statistics.SpecialFunctions;

public abstract class DiscreteProbabilityDistribution {
    public abstract double density(double var1);

    public abstract double cumulativeProbability(double var1);

    public Double inverseCumulativeProbability(double x1, double x2, double tol, double area) {
        if (area < 0.0 || area > 1.0) {
            return Double.NaN;
        }
        double ITMAX = 100.0;
        double EPS = 3.0E-7;
        double a = x1;
        double b = x2;
        double c = x2;
        double d = 0.0;
        double e = 0.0;
        double min1 = 0.0;
        double min2 = 0.0;
        double fa = this.cumulativeProbability(a) - area;
        double fb = this.cumulativeProbability(b) - area;
        d = 0.0;
        if (fa > 0.0 && fb > 0.0 || fa < 0.0 && fb < 0.0) {
            System.err.println("Root must be bracketed in zbrent");
        }
        c = b;
        double fc = fb;
        int iter = 1;
        while ((double)iter <= ITMAX) {
            if (fb > 0.0 && fc > 0.0 || fb < 0.0 && fc < 0.0) {
                c = a;
                fc = fa;
                e = d = b - a;
            }
            if (Math.abs(fc) < Math.abs(fb)) {
                a = b;
                b = c;
                c = a;
                fa = fb;
                fb = fc;
                fc = fa;
            }
            double tol1 = 2.0 * EPS * Math.abs(b) + 0.5 * tol;
            double xm = 0.5 * (c - b);
            if (Math.abs(xm) <= tol1 || fb == 0.0) {
                return new Double(Math.floor(b + 0.5));
            }
            if (Math.abs(e) >= tol1 && Math.abs(fa) > Math.abs(fb)) {
                double q;
                double p;
                double s = fb / fa;
                if (a == c) {
                    p = 2.0 * xm * s;
                    q = 1.0 - s;
                } else {
                    q = fa / fc;
                    double r = fb / fc;
                    p = s * (2.0 * xm * q * (q - r) - (b - a) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                }
                p = Math.abs(p);
                min1 = 3.0 * xm * q - Math.abs(tol1 * q);
                double d2 = min1 < (min2 = Math.abs(e * q)) ? min1 : min2;
                if (2.0 * p < d2) {
                    e = d;
                    d = p / q;
                } else {
                    e = d = xm;
                }
            } else {
                e = d = xm;
            }
            a = b;
            fa = fb;
            b = Math.abs(d) > tol1 ? (b += d) : (b += SpecialFunctions.sign(tol1, xm));
            fb = this.cumulativeProbability(b) - area;
            ++iter;
        }
        System.err.println("Maximum number of iterations exceeded in zbrent");
        return new Double(0.0);
    }
}

