/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.spreadsheet;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import org.statcato.Statcato;
import org.statcato.spreadsheet.RowHeaderTable;
import org.statcato.spreadsheet.Spreadsheet;

public class SpreadsheetScrollPane
extends JScrollPane {
    private Spreadsheet table;
    private RowHeaderTable header;
    private boolean dragged = false;
    private int startDraggedRow = -1;
    private int lastSelectedRow = -1;

    public SpreadsheetScrollPane(Statcato mTab) {
        super(new Spreadsheet(mTab));
        this.table = (Spreadsheet)this.getViewport().getView();
        this.header = new RowHeaderTable(this.table);
        this.setRowHeaderView(this.header);
        this.addRowHeaderMouseListeners();
    }

    public SpreadsheetScrollPane(Statcato mTab, Spreadsheet s) {
        super(s);
        this.table = s;
        this.header = new RowHeaderTable(this.table);
        this.setRowHeaderView(this.header);
        this.addRowHeaderMouseListeners();
    }

    public Spreadsheet getSpreadsheet() {
        return this.table;
    }

    public RowHeaderTable getRowHeaderTable() {
        return this.header;
    }

    public boolean getChangedStatus() {
        return this.table.getChangedStatus();
    }

    private void addRowHeaderMouseListeners() {
        MouseMotionAdapter motionListener = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!SpreadsheetScrollPane.this.dragged) {
                    return;
                }
                int row = SpreadsheetScrollPane.this.header.rowAtPoint(e.getPoint());
                ListSelectionModel headerSelection = SpreadsheetScrollPane.this.header.getSelectionModel();
                ListSelectionModel tableSelection = SpreadsheetScrollPane.this.table.getSelectionModel();
                if (row == -1) {
                    tableSelection.clearSelection();
                    headerSelection.clearSelection();
                    return;
                }
                int count = SpreadsheetScrollPane.this.table.getColumnCount();
                if (count != 0) {
                    SpreadsheetScrollPane.this.table.setColumnSelectionInterval(0, count - 1);
                }
                if (row < SpreadsheetScrollPane.this.startDraggedRow) {
                    tableSelection.setSelectionInterval(row, SpreadsheetScrollPane.this.startDraggedRow);
                } else {
                    tableSelection.setSelectionInterval(SpreadsheetScrollPane.this.startDraggedRow, row);
                }
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SpreadsheetScrollPane.this.dragged = false;
                SpreadsheetScrollPane.this.startDraggedRow = -1;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int row = SpreadsheetScrollPane.this.header.rowAtPoint(e.getPoint());
                ListSelectionModel headerSelection = SpreadsheetScrollPane.this.header.getSelectionModel();
                ListSelectionModel tableSelection = SpreadsheetScrollPane.this.table.getSelectionModel();
                if (SpreadsheetScrollPane.this.dragged) {
                    tableSelection.clearSelection();
                    headerSelection.clearSelection();
                    SpreadsheetScrollPane.this.dragged = false;
                    SpreadsheetScrollPane.this.startDraggedRow = -1;
                }
                if (row == -1) {
                    return;
                }
                SpreadsheetScrollPane.this.dragged = true;
                int count = SpreadsheetScrollPane.this.table.getColumnCount();
                if (count != 0) {
                    SpreadsheetScrollPane.this.table.setColumnSelectionInterval(0, count - 1);
                }
                tableSelection.addSelectionInterval(row, row);
                SpreadsheetScrollPane.this.startDraggedRow = row;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ListSelectionModel headerSelection = SpreadsheetScrollPane.this.header.getSelectionModel();
                ListSelectionModel tableSelection = SpreadsheetScrollPane.this.table.getSelectionModel();
                int row = SpreadsheetScrollPane.this.header.rowAtPoint(e.getPoint());
                if (row == -1) {
                    return;
                }
                int count = SpreadsheetScrollPane.this.table.getColumnCount();
                if (count != 0) {
                    SpreadsheetScrollPane.this.table.setColumnSelectionInterval(0, count - 1);
                }
                if (e.isShiftDown()) {
                    if (SpreadsheetScrollPane.this.lastSelectedRow != -1) {
                        if (SpreadsheetScrollPane.this.lastSelectedRow <= row) {
                            headerSelection.setSelectionInterval(SpreadsheetScrollPane.this.lastSelectedRow, row);
                            tableSelection.setSelectionInterval(SpreadsheetScrollPane.this.lastSelectedRow, row);
                        } else {
                            headerSelection.setSelectionInterval(row, SpreadsheetScrollPane.this.lastSelectedRow);
                            tableSelection.setSelectionInterval(row, SpreadsheetScrollPane.this.lastSelectedRow);
                        }
                    }
                } else if (e.isControlDown()) {
                    boolean old = headerSelection.getValueIsAdjusting();
                    headerSelection.setValueIsAdjusting(true);
                    int anchor = headerSelection.getAnchorSelectionIndex();
                    int lead = headerSelection.getLeadSelectionIndex();
                    if (!headerSelection.isSelectedIndex(row)) {
                        tableSelection.removeSelectionInterval(row, row);
                    } else {
                        tableSelection.addSelectionInterval(row, row);
                    }
                    headerSelection.setValueIsAdjusting(old);
                } else {
                    headerSelection.setSelectionInterval(row, row);
                    tableSelection.setSelectionInterval(row, row);
                }
                SpreadsheetScrollPane.this.lastSelectedRow = row;
            }
        };
        this.header.addMouseListener(mouseAdapter);
        this.header.addMouseMotionListener(motionListener);
    }
}

