/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.spreadsheet;

public class Cell {
    private String contents;
    private int row;
    private int column;
    private Double value;

    public Cell(String contents, int row, int column) {
        this.contents = contents.trim();
        this.row = row;
        this.column = column;
        try {
            double num = Double.parseDouble(contents);
            this.value = new Double(num);
        }
        catch (NumberFormatException e) {
            this.value = null;
        }
    }

    public String getContents() {
        return this.contents;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public String toString() {
        if (this.isNumeric()) {
            int places;
            double num = this.value;
            int sixPlaces = (int)Math.round((num - Math.floor(num)) * 1000000.0);
            for (places = 0; sixPlaces > 0 && places < 6; ++places) {
                sixPlaces = (int)((double)sixPlaces % Math.pow(10.0, 5 - places));
            }
            return String.format("%." + places + "f", num);
        }
        return this.contents;
    }

    public Double getNumValue() {
        return this.value;
    }

    public void setContents(String svalue) {
        this.contents = svalue.trim();
        try {
            double num = Double.parseDouble(this.contents);
            this.value = new Double(num);
        }
        catch (NumberFormatException e) {
            this.value = null;
        }
    }

    public void clear() {
        this.setContents("");
    }

    public void setRow(int row) {
        this.row = row;
    }

    public void setColumn(int col) {
        this.column = col;
    }

    public boolean equals(Cell cell) {
        return this.contents.equals(cell.getContents()) && this.row == cell.getRow() && this.column == cell.getColumn();
    }

    public boolean isNumeric() {
        return this.value != null;
    }

    public boolean hasData() {
        return !this.contents.equals("");
    }
}

