/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.file;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jfree.chart.JFreeChart;
import org.statcato.DatasheetTabbedPane;
import org.statcato.LogWindow;
import org.statcato.Statcato;
import org.statcato.file.ExtensionFileFilter;
import org.statcato.file.FileOperations;
import org.statcato.graph.StatcatoChartFrame;
import org.statcato.graph.StatcatoMultipleChartFrame;
import org.statcato.spreadsheet.Spreadsheet;
import org.statcato.spreadsheet.SpreadsheetModel;
import org.statcato.spreadsheet.SpreadsheetScrollPane;
import org.statcato.utils.HelperFunctions;
import org.statcato.utils.SetProjectAutoSaveTimer;

public class Project {
    private LogWindow Log;
    private DatasheetTabbedPane DatasheetPane;
    private Statcato app;
    private File savedFile;
    public static String extension = "stc";
    private File tempFile;
    private int AUTOSAVEINTERVAL = 300;
    private boolean DELETEAUTOSAVEFILE = true;
    SetProjectAutoSaveTimer timer;

    public Project(Statcato app) {
        this.Log = app.getLogTextPane();
        this.DatasheetPane = app.getDatasheetTabbedPane();
        this.app = app;
        this.tempFile = new File("~statcato.tmp." + HelperFunctions.getCurrentTimeString() + ".stc");
        this.timer = new SetProjectAutoSaveTimer(this, this.AUTOSAVEINTERVAL);
    }

    public void setAutoSaveInterval(int seconds) {
        this.AUTOSAVEINTERVAL = seconds;
        this.timer.setInterval(seconds);
    }

    public void setDeleteAutoSaveFile(boolean delete) {
        this.DELETEAUTOSAVEFILE = delete;
    }

    public boolean exists() {
        return !this.getName().equals("");
    }

    public boolean isModified() {
        return this.Log.getChangedStatus() || this.DatasheetPane.getChangedStatus();
    }

    public boolean writeToFile(boolean saveAs) {
        String path = "";
        if (this.savedFile != null && !saveAs) {
            path = this.savedFile.getPath();
            this.writeFileHelper(path, false);
            return true;
        }
        JFileChooser fc = new JFileChooser(FileOperations.getRecentProject() == null ? null : FileOperations.getRecentProject().getParentFile());
        ExtensionFileFilter filter = new ExtensionFileFilter("Statcato project file (*.stc)", extension);
        fc.addChoosableFileFilter(filter);
        fc.setAcceptAllFileFilterUsed(false);
        int returnValue = fc.showSaveDialog(this.app);
        if (returnValue == 0) {
            Object[] options;
            int choice;
            File file = fc.getSelectedFile();
            path = file.getPath();
            if (!path.toLowerCase().endsWith("." + extension)) {
                path = path + "." + extension;
                file = new File(path);
            }
            if (file.exists() && (choice = JOptionPane.showOptionDialog(this.app, "The specified file already exists.  Overwrite existing file?", "Overwrite file?", 0, 2, null, options = new Object[]{"Overwrite file", "Cancel"}, options[1])) != 0) {
                return false;
            }
            boolean success = this.writeFileHelper(path, false);
            if (!success) {
                return false;
            }
            this.savedFile = file;
            return true;
        }
        return false;
    }

    public File getFile() {
        return this.savedFile;
    }

    private boolean writeFileHelper(String path, boolean autoSave) {
        try {
            int i;
            String htmlSource = this.Log.getText();
            String htmlSource2 = "";
            if (htmlSource.indexOf("<body>") != -1) {
                int start = htmlSource.indexOf("<body>") + 6;
                htmlSource = htmlSource.substring(start);
                while (htmlSource.contains("<body>")) {
                    start = htmlSource.indexOf("<body>") + 6;
                    htmlSource = htmlSource.substring(start);
                }
                int end = htmlSource.indexOf("</body>");
                if (end == -1) {
                    end = htmlSource.length();
                }
                htmlSource = htmlSource.substring(0, end);
            }
            String[] lines = htmlSource.split("\n");
            for (int i2 = 0; i2 < lines.length; ++i2) {
                htmlSource2 = htmlSource2 + lines[i2];
            }
            htmlSource = "\n<html>\n<head>\n</head>\n<body>\n" + htmlSource2 + "\n</body>\n</html>\n";
            FileOutputStream fos = new FileOutputStream(path);
            GZIPOutputStream gz = new GZIPOutputStream(fos);
            ObjectOutputStream oos = new ObjectOutputStream(gz);
            oos.writeObject(htmlSource);
            if (!autoSave) {
                this.Log.setUnchangedStatus();
            }
            int count = this.DatasheetPane.getTabCount();
            oos.writeObject(new Integer(count));
            for (i = 0; i < count; ++i) {
                Spreadsheet s = ((SpreadsheetScrollPane)this.DatasheetPane.getComponentAt(i)).getSpreadsheet();
                if (!autoSave) {
                    s.setUnchangedStatus();
                    s.closeFile();
                }
                oos.writeObject(((SpreadsheetModel)s.getModel()).getTabDelimitedValues());
            }
            if (!autoSave) {
                this.DatasheetPane.resetTabTitles();
            }
            if ((count = this.app.getChartFrames().size()) != 0) {
                oos.writeObject(new Integer(count));
                for (i = 0; i < count; ++i) {
                    String title;
                    JFrame chartFrame;
                    JFrame frame = this.app.getChartFrames().get(i);
                    if (frame instanceof StatcatoChartFrame) {
                        chartFrame = (StatcatoChartFrame)frame;
                        title = ((StatcatoChartFrame)chartFrame).getChartTitle();
                        JFreeChart chart = ((StatcatoChartFrame)chartFrame).getChart();
                        try {
                            oos.writeObject(title);
                            oos.writeObject("s");
                            oos.writeObject(chart);
                            continue;
                        }
                        catch (IOException e) {
                            System.err.println("fail to write StatcatoChartFrame");
                            return false;
                        }
                    }
                    if (!(frame instanceof StatcatoMultipleChartFrame)) continue;
                    chartFrame = (StatcatoMultipleChartFrame)frame;
                    title = ((StatcatoMultipleChartFrame)chartFrame).getChartTitle();
                    ArrayList<JFreeChart> charts = ((StatcatoMultipleChartFrame)chartFrame).getCharts();
                    try {
                        oos.writeObject(title);
                        oos.writeObject("m" + charts.size());
                        for (int j = 0; j < charts.size(); ++j) {
                            oos.writeObject(charts.get(j));
                        }
                        continue;
                    }
                    catch (IOException e) {
                        System.err.println("fail to write StatcatoMultipleChartFrame");
                        return false;
                    }
                }
            }
            oos.flush();
            oos.close();
            gz.close();
            fos.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void autoSaveWrite() {
        if (this.writeFileHelper(this.tempFile.getPath(), true)) {
            this.app.restoreStatusTimer(1);
            this.app.setStatus("Auto save completed.");
        } else {
            this.app.restoreStatusTimer(1);
            this.app.setStatus("Auto save failed.");
        }
    }

    public String getName() {
        if (this.savedFile == null) {
            return "";
        }
        return this.savedFile.getName();
    }

    public boolean readFile(String path) {
        try {
            int i;
            ArrayList<JFrame> frames;
            String[] sheets;
            int count;
            String htmlSource;
            ObjectInputStream ois;
            GZIPInputStream gs;
            FileInputStream fis;
            block27: {
                fis = new FileInputStream(path);
                gs = new GZIPInputStream(fis);
                ois = new ObjectInputStream(gs);
                Object o = ois.readObject();
                if (!(o instanceof String)) {
                    return false;
                }
                htmlSource = (String)o;
                o = ois.readObject();
                if (!(o instanceof Integer)) {
                    return false;
                }
                count = (Integer)o;
                sheets = new String[count];
                for (int i2 = 0; i2 < count; ++i2) {
                    String s;
                    o = ois.readObject();
                    if (!(o instanceof String)) {
                        return false;
                    }
                    sheets[i2] = s = (String)o;
                }
                frames = new ArrayList<JFrame>();
                int countCharts = 0;
                try {
                    o = ois.readObject();
                    if (o == null) break block27;
                    if (!(o instanceof Integer)) {
                        System.err.println("num charts not an integer");
                        return false;
                    }
                    countCharts = (Integer)o;
                    for (i = 0; i < countCharts; ++i) {
                        String title;
                        try {
                            o = ois.readObject();
                            if (!(o instanceof String)) {
                                System.err.println("not a chart title");
                                return false;
                            }
                            title = (String)o;
                        }
                        catch (IOException ex) {
                            System.err.println("failed to read chart title");
                            return false;
                        }
                        try {
                            o = ois.readObject();
                            if (o instanceof String) {
                                String type = (String)o;
                                if (type.startsWith("s")) {
                                    try {
                                        o = ois.readObject();
                                        if (!(o instanceof JFreeChart)) {
                                            System.err.println("not a chart object");
                                            return false;
                                        }
                                        frames.add(new StatcatoChartFrame(title, (JFreeChart)o, this.app));
                                        continue;
                                    }
                                    catch (IOException ex) {
                                        System.err.println("failed to read chart object");
                                        return false;
                                    }
                                }
                                int chartCount = Integer.parseInt(type.substring(1));
                                ArrayList<JFreeChart> charts = new ArrayList<JFreeChart>();
                                for (int k = 0; k < chartCount; ++k) {
                                    try {
                                        o = ois.readObject();
                                        if (!(o instanceof JFreeChart)) {
                                            System.err.println("not a chart object");
                                            return false;
                                        }
                                        charts.add((JFreeChart)o);
                                        continue;
                                    }
                                    catch (IOException ex) {
                                        System.err.println("failed to read chart object");
                                        return false;
                                    }
                                }
                                frames.add(new StatcatoMultipleChartFrame(title, charts, this.app));
                                continue;
                            }
                            System.err.println("not a chart type indicator");
                            return false;
                        }
                        catch (IOException ex) {
                            System.err.println("failed to read chart type indicator");
                            return false;
                        }
                    }
                }
                catch (EOFException e) {
                    System.err.println("end of file");
                }
            }
            ois.close();
            gs.close();
            fis.close();
            if (this.close()) {
                this.Log.overwrite(htmlSource);
                this.Log.setUnchangedStatus();
                for (i = 0; i < count; ++i) {
                    this.DatasheetPane.addDatasheet(sheets[i], null);
                }
                for (i = 0; i < frames.size(); ++i) {
                    JFrame frame = (JFrame)frames.get(i);
                    this.app.addWindowFrame(frame);
                    frame.pack();
                    frame.setVisible(true);
                }
                this.savedFile = new File(path);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean close() {
        Object[] options = new Object[]{"Save Project", "Close Without Saving"};
        if (this.Log.getChangedStatus() || this.DatasheetPane.getChangedStatus()) {
            int choice = JOptionPane.showOptionDialog(this.app, "This project is not yet saved.", "Unsaved project...", 0, 3, null, options, options[0]);
            if (choice == -1) {
                return false;
            }
            if (choice == 0 && !this.writeToFile(false)) {
                return false;
            }
        }
        this.Log.clear();
        this.Log.setUnchangedStatus();
        this.DatasheetPane.removeAll();
        this.savedFile = null;
        this.app.removeChartFrames();
        return true;
    }

    public void exit() {
        if (this.DELETEAUTOSAVEFILE) {
            this.tempFile.delete();
        }
    }
}

