/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.nonparametrics;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.inferential.nonparametrics.WilcoxonSignedRankTest;
import org.statcato.utils.HelperFunctions;

public class WilcoxonSignedRankTestDialog
extends StatcatoDialog {
    private JComboBox AltComboBox;
    private JButton CancelButton;
    private JComboBox ColumnComboBox;
    private JLabel HyMedianLabel;
    private JTextField HyMedianTextField;
    private JButton OKButton;
    private JComboBox Sample1ComboBox;
    private JRadioButton Sample1RadioButton;
    private JComboBox Sample2ComboBox;
    private JRadioButton Sample2RadioButton;
    private JTextField SigTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;

    public WilcoxonSignedRankTestDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.app = (Statcato)parent;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        this.ParentSpreadsheet.populateComboBox(this.Sample1ComboBox);
        this.ParentSpreadsheet.populateComboBox(this.Sample2ComboBox);
        ButtonGroup group = new ButtonGroup();
        group.add(this.Sample2RadioButton);
        group.add(this.Sample1RadioButton);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-nonparam-wilcoxon");
        this.name = "Wilcoxon Signed Rank Test";
        this.description = "For performing the Wilcoxon Signed Rank Test for a single population mean or matched pairs.";
        this.helpStrings.add("Select whether there is one sample or two sapmles of matched pairs.  Select the column names in the drop-down menus.");
        this.helpStrings.add("Provide the alternative hypothesis and significance level.");
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jLabel8 = new JLabel();
        this.HyMedianTextField = new JTextField();
        this.AltComboBox = new JComboBox();
        this.HyMedianLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.Sample2ComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.Sample2RadioButton = new JRadioButton();
        this.Sample1ComboBox = new JComboBox();
        this.ColumnComboBox = new JComboBox();
        this.Sample1RadioButton = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.SigTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Wilcoxon Signed Rank Test");
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Alternative Hypothesis"));
        this.jLabel8.setText("<html>Alternative Hypothesis:  ");
        this.HyMedianTextField.setText("0");
        this.AltComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Less than", "Not Equal to", "Greater than"}));
        this.AltComboBox.setSelectedIndex(1);
        this.HyMedianLabel.setText("Hypothesized Median:");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel8, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.AltComboBox, -2, -1, -2)).addGroup(jPanel3Layout.createSequentialGroup().addGap(38, 38, 38).addComponent(this.HyMedianLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.HyMedianTextField, -2, 78, -2))).addContainerGap(42, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8, -2, -1, -2).addComponent(this.AltComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.HyMedianLabel).addComponent(this.HyMedianTextField, -2, -1, -2)).addContainerGap()));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.jLabel2.setText("Second Sample:");
        this.Sample2ComboBox.setEnabled(false);
        this.jLabel1.setText("First Sample:");
        this.Sample2RadioButton.setText("Two Samples (Matched Pairs)");
        this.Sample2RadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WilcoxonSignedRankTestDialog.this.Sample2RadioButtonStateChanged(evt);
            }
        });
        this.Sample1ComboBox.setEnabled(false);
        this.Sample1RadioButton.setSelected(true);
        this.Sample1RadioButton.setText("One Sample ");
        this.Sample1RadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WilcoxonSignedRankTestDialog.this.Sample1RadioButtonStateChanged(evt);
            }
        });
        this.jLabel4.setText("Sample in Column:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.Sample2RadioButton).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 11, Short.MAX_VALUE).addComponent(this.ColumnComboBox, -2, 114, -2)).addComponent(this.Sample1RadioButton, GroupLayout.Alignment.LEADING)).addGroup(jPanel1Layout.createSequentialGroup().addGap(39, 39, 39).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.Sample2ComboBox, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.Sample1ComboBox, 0, 114, Short.MAX_VALUE)))).addGap(39, 39, 39)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.Sample1RadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ColumnComboBox, -2, -1, -2).addComponent(this.jLabel4)).addGap(18, 18, 18).addComponent(this.Sample2RadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.Sample1ComboBox, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.Sample2ComboBox, -2, -1, -2).addComponent(this.jLabel2)).addGap(124, 124, 124)));
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WilcoxonSignedRankTestDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WilcoxonSignedRankTestDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Significance"));
        this.jLabel6.setText("Significance level:");
        this.SigTextField.setText("0.05");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SigTextField, -2, 81, -2).addContainerGap(98, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.SigTextField, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(91, 91, 91).addComponent(this.OKButton, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, 207, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 27, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton))));
        this.pack();
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.Sample1ComboBox);
        this.updateComboBox(this.Sample2ComboBox);
        this.updateComboBox(this.ColumnComboBox);
    }

    private void Sample2RadioButtonStateChanged(ChangeEvent evt) {
        if (this.Sample2RadioButton.isSelected()) {
            this.Sample1ComboBox.setEnabled(true);
            this.Sample2ComboBox.setEnabled(true);
        } else {
            this.Sample1ComboBox.setEnabled(false);
            this.Sample2ComboBox.setEnabled(false);
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        WilcoxonSignedRankTest st;
        double significance;
        this.app.compoundEdit = new DialogEdit("wilcoxon signed rank test");
        String heading = "Wilcoxon Signed Rank Test:";
        String text = "";
        String columnLabel1 = "";
        String columnLabel2 = "";
        double median = 0.0;
        try {
            median = Double.parseDouble(this.HyMedianTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid number for the hypothesized mean.");
            return;
        }
        int typeTest = this.AltComboBox.getSelectedIndex();
        try {
            significance = Double.parseDouble(this.SigTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the significance level.");
            return;
        }
        if (significance <= 0.0 || significance >= 1.0) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        heading = heading + "  Significance level = " + significance;
        if (this.Sample2RadioButton.isSelected()) {
            columnLabel1 = this.Sample1ComboBox.getSelectedItem().toString();
            Vector<Double> ColumnVector1 = new Vector();
            Vector<Double> ColumnVector2 = new Vector();
            if (columnLabel1.equals("")) {
                this.app.showErrorDialog("Select sample 1 input column.");
                return;
            }
            int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel1);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            ColumnVector1 = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (ColumnVector1 == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel1 + ": all data must be numbers.");
                return;
            }
            text = text + "Sample 1: " + columnLabel1 + "<br>";
            columnLabel2 = this.Sample2ComboBox.getSelectedItem().toString();
            if (columnLabel2.equals("")) {
                this.app.showErrorDialog("Select sample 2 input column.");
                return;
            }
            column = this.ParentSpreadsheet.parseColumnNumber(columnLabel2);
            StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            ColumnVector2 = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (ColumnVector2 == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel2 + ": all data must be numbers.");
                return;
            }
            text = text + "Sample 2: " + columnLabel2 + "<br>";
            Vector<Double> DiffVector = HelperFunctions.ComputeDiffVector(ColumnVector1, ColumnVector2);
            if (DiffVector == null) {
                this.app.showErrorDialog("There are unmatched pairs in the sample.");
                return;
            }
            text = text + "Difference of Matched Pairs " + columnLabel1 + " - " + columnLabel2 + "<br>";
            st = new WilcoxonSignedRankTest(DiffVector, median, typeTest, significance);
        } else {
            columnLabel1 = this.ColumnComboBox.getSelectedItem().toString();
            Vector<Double> ColumnVector1 = new Vector();
            if (columnLabel1.equals("")) {
                this.app.showErrorDialog("Select sample input column.");
                return;
            }
            int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel1);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            ColumnVector1 = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (ColumnVector1 == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel1 + ": all data must be numbers.");
                return;
            }
            text = text + "Single Sample: " + columnLabel1 + "<br>";
            st = new WilcoxonSignedRankTest(ColumnVector1, median, typeTest, significance);
        }
        text = text + "H<sub>0</sub>: = " + median + "<br>";
        text = text + "H<sub>1</sub>: ";
        text = typeTest == WilcoxonSignedRankTest.LESS ? text + " &lt; " : (typeTest == WilcoxonSignedRankTest.GREATER ? text + " &gt; " : text + " &ne; ");
        text = text + median + "<br>";
        text = text + st;
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void Sample1RadioButtonStateChanged(ChangeEvent evt) {
        if (this.Sample1RadioButton.isSelected()) {
            this.ColumnComboBox.setEnabled(true);
        } else {
            this.ColumnComboBox.setEnabled(false);
        }
    }
}

