/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.nonparametrics;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.inferential.nonparametrics.SignTest;
import org.statcato.utils.HelperFunctions;

public class MatchedPairSignTestDialog
extends StatcatoDialog {
    private JComboBox AltComboBox;
    private JButton CancelButton;
    private JLabel HyMedianLabel;
    private JTextField HyMedianTextField;
    private JTextField NumNegativeTextField;
    private JTextField NumPositiveTextField;
    private JButton OKButton;
    private JComboBox Sample1ComboBox;
    private JComboBox Sample2ComboBox;
    private JRadioButton SampleRadioButton;
    private JRadioButton SummaryRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel3;

    public MatchedPairSignTestDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.app = (Statcato)parent;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        this.ParentSpreadsheet.populateComboBox(this.Sample1ComboBox);
        this.ParentSpreadsheet.populateComboBox(this.Sample2ComboBox);
        ButtonGroup group = new ButtonGroup();
        group.add(this.SampleRadioButton);
        group.add(this.SummaryRadioButton);
        this.HyMedianLabel.setVisible(false);
        this.HyMedianTextField.setVisible(false);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-nonparam-2signtest");
        this.name = "2-Sample Matched-Pair Sign Test";
        this.description = "For performing the matched-pair sign test for two population means.";
        this.helpStrings.add("If individual samples are entered in columns of the datasheet, select the Samples in column: radio button, and select the column names in the drop-down menus.");
        this.helpStrings.add("To use summary statistics of the sample data, select the Summarized sample data: radio button, and input the number of positive and negative signs in the provided text fields.");
        this.helpStrings.add("Provide the alternative hypothesis.");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.NumNegativeTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.Sample2ComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.SampleRadioButton = new JRadioButton();
        this.Sample1ComboBox = new JComboBox();
        this.NumPositiveTextField = new JTextField();
        this.SummaryRadioButton = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel8 = new JLabel();
        this.HyMedianTextField = new JTextField();
        this.AltComboBox = new JComboBox();
        this.HyMedianLabel = new JLabel();
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("2-Sample Matched-Pair Sign Test");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.NumNegativeTextField.setEnabled(false);
        this.jLabel2.setText("Second Sample:");
        this.jLabel1.setText("First Sample:");
        this.jLabel4.setText("Number of Positive (+):");
        this.SampleRadioButton.setSelected(true);
        this.SampleRadioButton.setText("Samples in Columns");
        this.SampleRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MatchedPairSignTestDialog.this.SampleRadioButtonStateChanged(evt);
            }
        });
        this.NumPositiveTextField.setEnabled(false);
        this.SummaryRadioButton.setText("Summarized Sample Data");
        this.SummaryRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MatchedPairSignTestDialog.this.SummaryRadioButtonStateChanged(evt);
            }
        });
        this.jLabel3.setText("Number of Negative (-):");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SummaryRadioButton).addComponent(this.SampleRadioButton).addGroup(jPanel1Layout.createSequentialGroup().addGap(38, 38, 38).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.NumPositiveTextField, -1, 78, Short.MAX_VALUE).addComponent(this.NumNegativeTextField, -1, 78, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.Sample2ComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.Sample1ComboBox, 0, 114, Short.MAX_VALUE)))))).addContainerGap(63, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.SampleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.Sample1ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.Sample2ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SummaryRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.NumNegativeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.NumPositiveTextField, -2, -1, -2)).addContainerGap(14, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Alternative Hypothesis"));
        this.jLabel8.setText("<html>Alternative Hypothesis:  ");
        this.HyMedianTextField.setText("0");
        this.AltComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Less than", "Not Equal to", "Greater than"}));
        this.AltComboBox.setSelectedIndex(1);
        this.HyMedianLabel.setText("Hypothesized Median:");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel8, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.AltComboBox, -2, -1, -2)).addGroup(jPanel3Layout.createSequentialGroup().addGap(38, 38, 38).addComponent(this.HyMedianLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.HyMedianTextField, -2, 78, -2))).addContainerGap(42, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8, -2, -1, -2).addComponent(this.AltComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.HyMedianLabel).addComponent(this.HyMedianTextField, -2, -1, -2)).addContainerGap()));
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MatchedPairSignTestDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MatchedPairSignTestDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(97, 97, 97).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 36, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap()));
        this.pack();
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.Sample1ComboBox);
        this.updateComboBox(this.Sample2ComboBox);
    }

    private void SampleRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SampleRadioButton.isSelected()) {
            this.Sample1ComboBox.setEnabled(true);
            this.Sample2ComboBox.setEnabled(true);
        } else {
            this.Sample1ComboBox.setEnabled(false);
            this.Sample2ComboBox.setEnabled(false);
        }
    }

    private void SummaryRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SummaryRadioButton.isSelected()) {
            this.NumPositiveTextField.setEnabled(true);
            this.NumNegativeTextField.setEnabled(true);
        } else {
            this.NumPositiveTextField.setEnabled(false);
            this.NumNegativeTextField.setEnabled(false);
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        SignTest st;
        this.app.compoundEdit = new DialogEdit("matched-pair sign test");
        String heading = "Matched-Pair Sign Test:";
        String text = "";
        String columnLabel1 = "";
        String columnLabel2 = "";
        double median = 0.0;
        try {
            median = Double.parseDouble(this.HyMedianTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a valid number for the hypothesized mean.");
            return;
        }
        int typeTest = this.AltComboBox.getSelectedIndex();
        if (this.SampleRadioButton.isSelected()) {
            columnLabel1 = this.Sample1ComboBox.getSelectedItem().toString();
            Vector<Double> ColumnVector1 = new Vector();
            Vector<Double> ColumnVector2 = new Vector();
            if (columnLabel1.equals("")) {
                this.app.showErrorDialog("Select sample 1 input column.");
                return;
            }
            int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel1);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            ColumnVector1 = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (ColumnVector1 == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel1 + ": all data must be numbers.");
                return;
            }
            text = text + "Sample 1: " + columnLabel1 + "<br>";
            columnLabel2 = this.Sample2ComboBox.getSelectedItem().toString();
            if (columnLabel2.equals("")) {
                this.app.showErrorDialog("Select sample 2 input column.");
                return;
            }
            column = this.ParentSpreadsheet.parseColumnNumber(columnLabel2);
            StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            ColumnVector2 = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (ColumnVector2 == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel2 + ": all data must be numbers.");
                return;
            }
            text = text + "Sample 2: " + columnLabel2 + "<br>";
            Vector<Double> DiffVector = HelperFunctions.ComputeDiffVector(ColumnVector1, ColumnVector2);
            if (DiffVector == null) {
                this.app.showErrorDialog("There are unmatched pairs in the sample.");
                return;
            }
            text = text + "Difference of Matched Pairs " + columnLabel1 + " - " + columnLabel2 + "<br>";
            st = new SignTest(DiffVector, median, typeTest);
        } else {
            int numNegative;
            int numPositive;
            try {
                numPositive = Integer.parseInt(this.NumPositiveTextField.getText());
                numNegative = Integer.parseInt(this.NumNegativeTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Invalid summary data.");
                return;
            }
            text = text + "Input: Summary data<br>";
            st = new SignTest(numPositive, numNegative, median, typeTest);
        }
        text = text + "H<sub>0</sub>: &mu;<sub>1</sub> - &mu;<sub>2</sub> OR ";
        text = text + "median<sub>pairwise differences</sub> = " + median + "<br>";
        text = text + "H<sub>1</sub>: &mu;<sub>1</sub> - &mu;<sub>2</sub> OR ";
        text = text + "median<sub>pairwise differences</sub>";
        text = typeTest == SignTest.LESS ? text + " &lt; " : (typeTest == SignTest.GREATER ? text + " &gt; " : text + " &ne; ");
        text = text + median + "<br>";
        text = text + st;
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

