/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.ci;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.statistics.inferential.CIMatchedPairs;
import org.statcato.statistics.inferential.ConfidenceInterval;
import org.statcato.utils.HelperFunctions;

public class CIMatchedPairsDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JTextField ConfidenceTextField;
    private JTextField MeanTextField;
    private JButton OKButton;
    private JComboBox Sample1ComboBox;
    private JComboBox Sample2ComboBox;
    private JRadioButton SampleRadioButton;
    private JTextField SizeTextField;
    private JTextField StdevTextField;
    private JRadioButton SummaryRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public CIMatchedPairsDialog(Frame parent, boolean modal, Statcato mTab) {
        super(parent, modal);
        this.initComponents();
        this.app = mTab;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.SampleRadioButton);
        group1.add(this.SummaryRadioButton);
        this.ParentSpreadsheet.populateComboBox(this.Sample1ComboBox);
        this.ParentSpreadsheet.populateComboBox(this.Sample2ComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("stat-ci-matched");
        this.name = "Confidence Interval: Matched Pairs";
        this.description = "For computing confidence intervals for the mean of the differences between matched pairs.";
        this.helpStrings.add("The sample data can be inputted in one of two ways...");
        this.helpStrings.add("Samples in columns: The sample matched pairs are provided in two columns, and the two values in a matched pair are provided in the same row.");
        this.helpStrings.add("Summarized Sample Data: The sample size, mean, and standard deviation are provided (instead of individual sample values).");
        this.helpStrings.add("The confidence level must be between 0 and 1.");
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.Sample1ComboBox);
        this.updateComboBox(this.Sample2ComboBox);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel1 = new JLabel();
        this.SummaryRadioButton = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.Sample1ComboBox = new JComboBox();
        this.Sample2ComboBox = new JComboBox();
        this.SizeTextField = new JTextField();
        this.SampleRadioButton = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.MeanTextField = new JTextField();
        this.StdevTextField = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.ConfidenceTextField = new JTextField();
        this.jLabel7 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Confidence Interval: Matched Pairs");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CIMatchedPairsDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CIMatchedPairsDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Inputs"));
        this.jLabel3.setText("Sample Size:");
        this.jLabel5.setText("Standard Deviation:");
        this.jLabel1.setText("First Sample:");
        this.SummaryRadioButton.setText("Summarized Sample Data");
        this.SummaryRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CIMatchedPairsDialog.this.SummaryRadioButtonStateChanged(evt);
            }
        });
        this.jLabel4.setText("Mean:");
        this.SizeTextField.setEnabled(false);
        this.SampleRadioButton.setSelected(true);
        this.SampleRadioButton.setText("Samples in Columns");
        this.SampleRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CIMatchedPairsDialog.this.SampleRadioButtonStateChanged(evt);
            }
        });
        this.jLabel2.setText("Second Sample:");
        this.MeanTextField.setEnabled(false);
        this.StdevTextField.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.SummaryRadioButton).addComponent(this.SampleRadioButton).addGroup(jPanel1Layout.createSequentialGroup().addGap(38, 38, 38).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.StdevTextField, -1, 76, Short.MAX_VALUE).addComponent(this.MeanTextField, -1, 78, Short.MAX_VALUE).addComponent(this.SizeTextField, -1, 78, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.Sample2ComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.Sample1ComboBox, 0, 104, Short.MAX_VALUE)))))).addContainerGap(64, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.MeanTextField, this.SizeTextField, this.StdevTextField);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.SampleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.Sample1ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.Sample2ComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SummaryRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.SizeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.MeanTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.StdevTextField, -2, -1, -2)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Confidence"));
        this.jLabel6.setText("Confidence level:");
        this.ConfidenceTextField.setText("0.95");
        this.jLabel7.setText("0 - 1.00 (e.g. 0.95)");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ConfidenceTextField, -2, 81, -2).addGap(10, 10, 10).addComponent(this.jLabel7).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.ConfidenceTextField, -2, -1, -2).addComponent(this.jLabel7)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(85, 85, 85).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.CancelButton))).addContainerGap()));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addContainerGap()));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        double confidenceLevel;
        this.app.compoundEdit = new DialogEdit("CI matched pairs");
        int n = 0;
        double s = 0.0;
        double mean = 0.0;
        String heading = "Confidence Interval - Matched Pairs:";
        String text = "";
        try {
            confidenceLevel = Double.parseDouble(this.ConfidenceTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
            this.app.showErrorDialog("Enter a number between 0 and 1 for the confidence level.");
            return;
        }
        heading = heading + "  confidence level = " + confidenceLevel;
        String columnLabel1 = "";
        String columnLabel2 = "";
        if (this.SampleRadioButton.isSelected()) {
            columnLabel1 = this.Sample1ComboBox.getSelectedItem().toString();
            Vector<Double> ColumnVector1 = new Vector();
            Vector<Double> ColumnVector2 = new Vector();
            if (columnLabel1.equals("")) {
                this.app.showErrorDialog("Select sample 1 input column.");
                return;
            }
            int column = this.ParentSpreadsheet.parseColumnNumber(columnLabel1);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            ColumnVector1 = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (ColumnVector1 == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel1 + ": all data must be numbers.");
                return;
            }
            text = text + "Sample 1: " + columnLabel1 + "<br>";
            columnLabel2 = this.Sample2ComboBox.getSelectedItem().toString();
            if (columnLabel2.equals("")) {
                this.app.showErrorDialog("Select sample 2 input column.");
                return;
            }
            column = this.ParentSpreadsheet.parseColumnNumber(columnLabel2);
            StrColumnVector = this.ParentSpreadsheet.getColumn(column);
            ColumnVector2 = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (ColumnVector2 == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel2 + ": all data must be numbers.");
                return;
            }
            text = text + "Sample 2: " + columnLabel2 + "<br>";
            Vector<Double> DiffVector = HelperFunctions.ComputeDiffVector(ColumnVector1, ColumnVector2);
            if (DiffVector == null) {
                this.app.showErrorDialog("There are unmatched pairs in the sample.");
                return;
            }
            n = BasicStatistics.Nnonmissing(DiffVector);
            mean = BasicStatistics.mean(DiffVector);
            s = BasicStatistics.stdev(DiffVector);
        } else {
            try {
                n = Integer.parseInt(this.SizeTextField.getText());
                if (n < 1) {
                    throw new NumberFormatException();
                }
                mean = Double.parseDouble(this.MeanTextField.getText());
                s = Double.parseDouble(this.StdevTextField.getText());
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Invalid summary data.");
                return;
            }
            text = text + "Input: Summary data<br>";
        }
        CIMatchedPairs CI = new CIMatchedPairs(confidenceLevel, n, mean, s);
        text = text + "Difference of Matched Pairs " + columnLabel1 + " - " + columnLabel2 + "<br>";
        text = text + "<br><table border='1'>";
        text = text + "<tr><td>N</td><td>Mean</td><td>Stdev</td><td>Margin of Error</td><td>";
        text = text + HelperFunctions.formatFloat(confidenceLevel * 100.0, 2) + "%CI</td></tr>";
        text = text + "<tr><td>" + n + "</td><td>" + HelperFunctions.formatFloat(mean, 3) + "</td><td>" + HelperFunctions.formatFloat(s, 3) + "</td><td>" + HelperFunctions.formatFloat(((ConfidenceInterval)CI).marginOfError(), 3) + "</td><td>" + CI.toString() + "</td></tr></table>";
        this.app.addLogParagraph(heading, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void SampleRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SampleRadioButton.isSelected()) {
            this.Sample1ComboBox.setEnabled(true);
            this.Sample2ComboBox.setEnabled(true);
        } else {
            this.Sample1ComboBox.setEnabled(false);
            this.Sample2ComboBox.setEnabled(false);
        }
    }

    private void SummaryRadioButtonStateChanged(ChangeEvent evt) {
        if (this.SummaryRadioButton.isSelected()) {
            this.SizeTextField.setEnabled(true);
            this.MeanTextField.setEnabled(true);
            this.StdevTextField.setEnabled(true);
        } else {
            this.SizeTextField.setEnabled(false);
            this.MeanTextField.setEnabled(false);
            this.StdevTextField.setEnabled(false);
        }
    }
}

