/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.stat.basicstats;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.JFreeChart;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.graph.GraphFactory;
import org.statcato.graph.StatcatoChartFrame;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.NormalityTest;
import org.statcato.utils.HelperFunctions;

public class NormalityTestDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JComboBox ColComboBox;
    private JRadioButton DataRadioButton;
    private JCheckBox LineCheckBox;
    private JCheckBox NormalPlotCheckBox;
    private JButton OKButton;
    private JPanel PlotPanel;
    private JComboBox SigComboBox;
    private JTextField TitleTextField;
    private JRadioButton ZscoresRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JTextField xTextField;
    private JTextField yTextField;

    public NormalityTestDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.app = (Statcato)parent;
        this.ParentSpreadsheet = this.app.getSpreadsheet();
        this.initComponents();
        this.customInitComponents();
        this.setHelpFile("stat-basic-normality");
        this.name = "Normality Test";
        this.description = "For performing the Ryan-Joiner normality test and creating a normal quantile plot for a set of sample data values. ";
        this.helpStrings.add("Select the column containing the data values in the Input Variable drop-down menu.");
        this.helpStrings.add("Select the significance level used in the Ryan-Joiner normality test.");
        this.helpStrings.add("Select the Generate normal quantile plot check box if a normal quantile plot for the input data should be displayed.");
        this.pack();
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.ColComboBox);
    }

    private void customInitComponents() {
        this.ParentSpreadsheet.populateComboBox(this.ColComboBox);
        ButtonGroup group = new ButtonGroup();
        group.add(this.DataRadioButton);
        group.add(this.ZscoresRadioButton);
        this.getRootPane().setDefaultButton(this.OKButton);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.ColComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.PlotPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.yTextField = new JTextField();
        this.TitleTextField = new JTextField();
        this.xTextField = new JTextField();
        this.LineCheckBox = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.DataRadioButton = new JRadioButton();
        this.ZscoresRadioButton = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.SigComboBox = new JComboBox();
        this.jLabel6 = new JLabel();
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.NormalPlotCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Normality Test");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Input Variable"));
        this.ColComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                NormalityTestDialog.this.ColComboBoxItemStateChanged(evt);
            }
        });
        this.jLabel1.setText("Select the column containing sample data:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.ColComboBox, -2, 108, -2)).addComponent(this.jLabel1)).addContainerGap(30, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ColComboBox, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.PlotPanel.setBorder(BorderFactory.createTitledBorder("Graph Options"));
        this.jLabel2.setText("Plot Title:");
        this.TitleTextField.setText("Normal Quantile Plot");
        this.LineCheckBox.setSelected(true);
        this.LineCheckBox.setText("Show regression line");
        this.jLabel4.setText("Y-axis Label:");
        this.jLabel3.setText("X-axis Label:");
        this.jLabel5.setText("X-axis values represent:");
        this.DataRadioButton.setSelected(true);
        this.DataRadioButton.setText("data");
        this.ZscoresRadioButton.setText("z-scores");
        GroupLayout PlotPanelLayout = new GroupLayout(this.PlotPanel);
        this.PlotPanel.setLayout(PlotPanelLayout);
        PlotPanelLayout.setHorizontalGroup(PlotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(PlotPanelLayout.createSequentialGroup().addContainerGap().addGroup(PlotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(PlotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(PlotPanelLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xTextField)).addGroup(PlotPanelLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.TitleTextField, -2, 231, -2)).addGroup(PlotPanelLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yTextField))).addGroup(PlotPanelLayout.createSequentialGroup().addGroup(PlotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.LineCheckBox).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.DataRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ZscoresRadioButton))).addContainerGap(-1, Short.MAX_VALUE)));
        PlotPanelLayout.setVerticalGroup(PlotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(PlotPanelLayout.createSequentialGroup().addContainerGap().addGroup(PlotPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.TitleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(PlotPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.xTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(PlotPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.yTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.LineCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(PlotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ZscoresRadioButton).addGroup(PlotPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.DataRadioButton))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Normality Test (Ryan-Joiner)"));
        this.SigComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"0.01", "0.05", "0.10"}));
        this.jLabel6.setText("Significance Level:");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.SigComboBox, -2, 125, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.SigComboBox, -2, -1, -2)).addContainerGap(23, Short.MAX_VALUE)));
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NormalityTestDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NormalityTestDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.NormalPlotCheckBox.setSelected(true);
        this.NormalPlotCheckBox.setText("Generate normal quantile plot");
        this.NormalPlotCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NormalityTestDialog.this.NormalPlotCheckBoxStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.PlotPanel, -2, -1, -2).addComponent(this.NormalPlotCheckBox))).addGroup(layout.createSequentialGroup().addGap(214, 214, 214).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap()));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.NormalPlotCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.PlotPanel, -2, -1, -2))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addGap(20, 20, 20)));
        this.pack();
    }

    private void ColComboBoxItemStateChanged(ItemEvent evt) {
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("normality test");
        String heading = "Normality Test";
        if (this.ColComboBox.getSelectedIndex() == 0) {
            this.app.showErrorDialog("Select the column containing the values to be plotted.");
            return;
        }
        String yCol = (String)this.ColComboBox.getSelectedItem();
        int yColumn = this.ParentSpreadsheet.parseColumnNumber(yCol);
        Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(yColumn);
        Vector<Double> YColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
        if (YColumnVector == null) {
            this.app.showErrorDialog("Invalid input column " + yCol + ": all data must be numbers.");
            return;
        }
        YColumnVector = HelperFunctions.removeNullValues(YColumnVector);
        String text = "Input variable: " + yCol + "<br>";
        double significance = Double.parseDouble((String)this.SigComboBox.getSelectedItem());
        NormalityTest normalityTest = new NormalityTest(YColumnVector, significance);
        text = text + normalityTest;
        this.app.addLogParagraph(heading, text);
        if (this.NormalPlotCheckBox.isSelected()) {
            this.CreatePlot(YColumnVector);
        }
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    private void CreatePlot(Vector<Double> YColumnVector) {
        JFreeChart plot = GraphFactory.createNormalQuantilePlot(YColumnVector, this.TitleTextField.getText(), this.xTextField.getText(), this.yTextField.getText(), this.DataRadioButton.isSelected(), this.LineCheckBox.isSelected());
        StatcatoChartFrame frame = new StatcatoChartFrame(this.TitleTextField.getText(), plot, this.app);
        frame.pack();
        frame.setVisible(true);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void NormalPlotCheckBoxStateChanged(ChangeEvent evt) {
        if (this.NormalPlotCheckBox.isSelected()) {
            this.PlotPanel.setVisible(true);
            this.pack();
        } else {
            this.PlotPanel.setVisible(false);
            this.pack();
        }
    }
}

