/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.graph;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.graph.GraphFactory;
import org.statcato.graph.StatcatoChartFrame;
import org.statcato.spreadsheet.Cell;
import org.statcato.statistics.BasicStatistics;
import org.statcato.utils.HelperFunctions;

public class HistogramDialog
extends StatcatoDialog {
    private JRadioButton BetweenRadioButton;
    private JButton CancelButton;
    private JRadioButton CenterRadioButton;
    private JTextField ClassWidthTextField;
    private JRadioButton FreqRadioButton;
    private JComboBox GroupByComboBox;
    private JList InputVarList;
    private JCheckBox LegendCheckBox;
    private JTextField MaxTextField;
    private JTextField Min2TextField;
    private JTextField MinTextField;
    private JTextField NumBinsTextField;
    private JButton OKButton;
    private JRadioButton RelFreqRadioButton;
    private JTextField TitleTextField;
    private JRadioButton X1RadioButton;
    private JRadioButton X2RadioButton;
    private JTextField XTextField;
    private JTextField YTextField;
    private JTextField YTickMarkTextField;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;

    public HistogramDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.FreqRadioButton);
        group1.add(this.RelFreqRadioButton);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.CenterRadioButton);
        group2.add(this.BetweenRadioButton);
        ButtonGroup group3 = new ButtonGroup();
        group3.add(this.X1RadioButton);
        group3.add(this.X2RadioButton);
        this.ParentSpreadsheet.populateColumnsList(this.InputVarList);
        this.ParentSpreadsheet.populateComboBox(this.GroupByComboBox);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("graph-histogram");
        this.name = "Histogram";
        this.description = "For creating histograms that show the frequencies of a number of bins (or classes) with numerical boundaries. ";
        this.helpStrings.add("Select the column variable(s) containing data values for which the plot will be created. A different color is used for each column variable.");
        this.helpStrings.add("Select whether to plot the frequencies or the relative frequencies of the bins.");
        this.helpStrings.add("Select the method of binning values on the x-axis.");
        this.helpStrings.add("Specify a plot title and labels for the axes.");
        this.pack();
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.GroupByComboBox);
        this.updateColumnsList(this.InputVarList);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jLabel14 = new JLabel();
        this.jLabel20 = new JLabel();
        this.jPanel1 = new JPanel();
        this.GroupByComboBox = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.InputVarList = new JList();
        this.jLabel1 = new JLabel();
        this.RelFreqRadioButton = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.FreqRadioButton = new JRadioButton();
        this.jLabel8 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel13 = new JLabel();
        this.jLabel22 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel10 = new JLabel();
        this.X2RadioButton = new JRadioButton();
        this.X1RadioButton = new JRadioButton();
        this.jLabel12 = new JLabel();
        this.jLabel19 = new JLabel();
        this.Min2TextField = new JTextField();
        this.jLabel7 = new JLabel();
        this.NumBinsTextField = new JTextField();
        this.CenterRadioButton = new JRadioButton();
        this.MinTextField = new JTextField();
        this.XTextField = new JTextField();
        this.jLabel23 = new JLabel();
        this.MaxTextField = new JTextField();
        this.jLabel9 = new JLabel();
        this.BetweenRadioButton = new JRadioButton();
        this.jLabel11 = new JLabel();
        this.ClassWidthTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel16 = new JLabel();
        this.YTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel17 = new JLabel();
        this.YTickMarkTextField = new JTextField();
        this.jLabel15 = new JLabel();
        this.jPanel4 = new JPanel();
        this.TitleTextField = new JTextField();
        this.LegendCheckBox = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jLabel18 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Histogram");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistogramDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistogramDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jLabel14.setText("jLabel14");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Graph Variables"));
        this.GroupByComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                HistogramDialog.this.GroupByComboBoxItemStateChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.InputVarList);
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Graph Variables:");
        this.RelFreqRadioButton.setText("Relative Frequency");
        this.jLabel2.setText("Ctrl-click to select multiple variables");
        this.jLabel4.setText("<html>Grouped By Categories in:<br> [optional]");
        this.FreqRadioButton.setSelected(true);
        this.FreqRadioButton.setText("Frequency");
        this.jLabel8.setFont(new Font("Tahoma", 1, 11));
        this.jLabel8.setText("Heights of bars represent:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jScrollPane1, -2, 125, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGap(36, 36, 36).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.FreqRadioButton).addComponent(this.RelFreqRadioButton))).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel8)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.GroupByComboBox, 0, 76, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 89, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4, -2, -1, -2).addComponent(this.GroupByComboBox, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.FreqRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.RelFreqRadioButton).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("X-Axis"));
        this.jLabel13.setText("Position of tick marks:");
        this.jLabel22.setText("Minimum:");
        this.jLabel21.setText("Class width:");
        this.jLabel10.setText("Maximum:");
        this.X2RadioButton.setText("Provide the class width and the minimum");
        this.X2RadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HistogramDialog.this.X2RadioButtonStateChanged(evt);
            }
        });
        this.X1RadioButton.setSelected(true);
        this.X1RadioButton.setText("Provide the number of classes, minimum, and maximum");
        this.X1RadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HistogramDialog.this.X1RadioButtonStateChanged(evt);
            }
        });
        this.jLabel12.setText("[automatic if left blank]");
        this.jLabel19.setText("Class width = (maximum - minimum) / classes");
        this.Min2TextField.setEnabled(false);
        this.jLabel7.setText("Number of bins (classes):");
        this.NumBinsTextField.setText("10");
        this.CenterRadioButton.setText("Center of bar");
        this.jLabel23.setText("[automatic if left blank]");
        this.jLabel9.setText("Minimum:");
        this.BetweenRadioButton.setSelected(true);
        this.BetweenRadioButton.setText("Between bars");
        this.jLabel11.setFont(new Font("Tahoma", 1, 11));
        this.jLabel11.setText("X-axis (horizontal)");
        this.ClassWidthTextField.setEnabled(false);
        this.jLabel6.setText("Label:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11).addGroup(jPanel2Layout.createSequentialGroup().addGap(22, 22, 22).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CenterRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.BetweenRadioButton)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.XTextField, -2, 140, -2)).addComponent(this.X2RadioButton).addComponent(this.X1RadioButton).addGroup(jPanel2Layout.createSequentialGroup().addGap(21, 21, 21).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.NumBinsTextField, -2, 72, -2)).addComponent(this.jLabel19).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.MinTextField, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.MaxTextField, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel12)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel21).addComponent(this.jLabel22)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.Min2TextField).addComponent(this.ClassWidthTextField, -2, 79, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel23))))))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(0, this.MaxTextField, this.MinTextField, this.NumBinsTextField);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.X1RadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.NumBinsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.MinTextField, -2, -1, -2).addComponent(this.jLabel10).addComponent(this.MaxTextField, -2, -1, -2).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.X2RadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel21).addComponent(this.ClassWidthTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.Min2TextField, -2, -1, -2).addComponent(this.jLabel23)).addComponent(this.jLabel22)).addGap(22, 22, 22).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.XTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.CenterRadioButton).addComponent(this.BetweenRadioButton)).addContainerGap(15, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Y-Axis"));
        this.jLabel16.setText("Tick mark units:");
        this.jLabel5.setText("Label:");
        this.jLabel17.setText("automatic if left blank");
        this.jLabel15.setFont(new Font("Tahoma", 1, 11));
        this.jLabel15.setText("Y-axis (vertical)");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15).addGroup(jPanel3Layout.createSequentialGroup().addGap(24, 24, 24).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.YTickMarkTextField, -2, 89, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel17)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.YTextField, -2, 305, -2))))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.YTextField, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.YTickMarkTextField, -2, -1, -2).addComponent(this.jLabel17).addComponent(this.jLabel16)).addContainerGap(23, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Other Options"));
        this.TitleTextField.setText("Histogram");
        this.LegendCheckBox.setSelected(true);
        this.LegendCheckBox.setText("Show Legend");
        this.jLabel3.setText("Title:");
        this.jLabel18.setFont(new Font("Tahoma", 1, 11));
        this.jLabel18.setText("Plot");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.LegendCheckBox).addComponent(this.jLabel18).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.TitleTextField, -2, 194, -2)))));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel18).addGap(15, 15, 15).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.TitleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.LegendCheckBox).addContainerGap(10, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel20)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addGap(8, 8, 8)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel4, -2, -1, -2).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton))).addContainerGap()));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        int i;
        double classWidth;
        int bins;
        TreeSet<String> groupSet;
        boolean hasByVar;
        Vector<Cell> byVarColVector;
        HistogramDataset dataset;
        String text;
        int[] columnNumbers;
        Object[] SelectedColumns;
        block42: {
            this.app.compoundEdit = new DialogEdit("histogram");
            SelectedColumns = this.InputVarList.getSelectedValues();
            columnNumbers = this.ParentSpreadsheet.convertColumnLabelsToNumbers(SelectedColumns);
            if (columnNumbers.length == 0) {
                this.app.showErrorDialog("Select at least one input variable.");
                return;
            }
            text = "";
            dataset = new HistogramDataset();
            if (this.FreqRadioButton.isSelected()) {
                dataset.setType(HistogramType.FREQUENCY);
            } else {
                dataset.setType(HistogramType.RELATIVE_FREQUENCY);
            }
            String byVarLabel = this.GroupByComboBox.getSelectedItem().toString();
            int byVarColNum = -1;
            byVarColVector = null;
            hasByVar = false;
            groupSet = new TreeSet<String>();
            if (!byVarLabel.equals("")) {
                text = text + "Group by " + byVarLabel + "<br>";
                hasByVar = true;
                byVarColNum = this.ParentSpreadsheet.parseColumnNumber(byVarLabel);
                byVarColVector = this.ParentSpreadsheet.getColumn(byVarColNum);
                Enumeration<Cell> e = byVarColVector.elements();
                while (e.hasMoreElements()) {
                    Cell next = e.nextElement();
                    if (next.getContents().equals("")) continue;
                    groupSet.add(next.getContents());
                }
            }
            bins = -1;
            classWidth = -1.0;
            if (this.X1RadioButton.isSelected()) {
                try {
                    bins = Integer.parseInt(this.NumBinsTextField.getText());
                    if (bins < 1) {
                        throw new NumberFormatException();
                    }
                    break block42;
                }
                catch (NumberFormatException e) {
                    this.app.showErrorDialog("Enter a positive integer for the number of bins");
                    return;
                }
            }
            try {
                classWidth = Double.parseDouble(this.ClassWidthTextField.getText());
                if (classWidth <= 0.0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a valid class width.");
                return;
            }
            text = text + "Class width = " + classWidth + "<br>";
        }
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        boolean useUserMax = false;
        boolean useUserMin = false;
        if (this.X1RadioButton.isSelected()) {
            if (!this.MinTextField.getText().equals("") || !this.MaxTextField.getText().equals("")) {
                try {
                    min = Double.parseDouble(this.MinTextField.getText());
                }
                catch (NumberFormatException e) {
                    this.app.showErrorDialog("Enter a valid minimum bin boundary value.");
                    return;
                }
                try {
                    max = Double.parseDouble(this.MaxTextField.getText());
                }
                catch (NumberFormatException e) {
                    this.app.showErrorDialog("Enter a valid maximum bin boundary value.");
                    return;
                }
                if (min >= max) {
                    this.app.showErrorDialog("Minimum must be less than maximum.");
                    return;
                }
                useUserMax = true;
                useUserMin = true;
            }
        } else if (!this.Min2TextField.getText().equals("")) {
            try {
                min = Double.parseDouble(this.Min2TextField.getText());
                max = min + classWidth;
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a valid minimum bin boundary value.");
                return;
            }
            useUserMin = true;
        }
        Vector<Vector<Double>> vectors = new Vector<Vector<Double>>();
        Vector<String> labels = new Vector<String>();
        text = text + "Graph variable(s) = ";
        for (i = 0; i < columnNumbers.length; ++i) {
            double thisMin;
            double thisMax;
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(columnNumbers[i]);
            String columnLabel = (String)SelectedColumns[i];
            text = text + columnLabel + " ";
            Vector<Double> ColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (ColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + columnLabel + ": all data must be numbers.");
                return;
            }
            if (!useUserMax && (thisMax = BasicStatistics.max(HelperFunctions.removeNullValues(ColumnVector)).doubleValue()) > max) {
                max = thisMax;
            }
            if (!useUserMin && (thisMin = BasicStatistics.min(HelperFunctions.removeNullValues(ColumnVector)).doubleValue()) < min) {
                min = thisMin;
            }
            if (hasByVar) {
                for (String groupName : groupSet) {
                    Vector<Double> subVector = new Vector<Double>(0);
                    for (int j = 0; j < ColumnVector.size(); ++j) {
                        String label = byVarColVector.elementAt(j).getContents();
                        if (!label.equals(groupName)) continue;
                        subVector.addElement(ColumnVector.elementAt(j));
                    }
                    subVector = HelperFunctions.removeNullValues(subVector);
                    labels.addElement(columnLabel + "-" + groupName);
                    if (max != -1.0 && min != -1.0) {
                        vectors.addElement(subVector);
                        continue;
                    }
                    vectors.addElement(subVector);
                }
                continue;
            }
            ColumnVector = HelperFunctions.removeNullValues(ColumnVector);
            labels.addElement(columnLabel);
            if (max != -1.0 && min != -1.0) {
                vectors.addElement(ColumnVector);
                continue;
            }
            vectors.addElement(ColumnVector);
        }
        if (this.X2RadioButton.isSelected()) {
            bins = 0;
            while ((double)bins * classWidth + min < max) {
                ++bins;
            }
            max = min + (double)bins * classWidth;
        }
        for (i = 0; i < vectors.size(); ++i) {
            Vector vec = (Vector)vectors.elementAt(i);
            String label = (String)labels.elementAt(i);
            dataset.addSeries((Comparable)((Object)label), HelperFunctions.ConvertDoubleVectorToArray(vec), bins, min, max);
        }
        TickUnits units = new TickUnits();
        for (int i2 = 0; i2 < dataset.getSeriesCount(); ++i2) {
            double width = dataset.getEndX(i2, 0).doubleValue() - dataset.getStartX(i2, 0).doubleValue();
            units.add(new NumberTickUnit(width));
        }
        double minBinStart = dataset.getStartX(0, 0).doubleValue();
        double minBin = dataset.getEndX(0, 0).doubleValue() - dataset.getStartX(0, 0).doubleValue();
        for (int i3 = 1; i3 < dataset.getSeriesCount(); ++i3) {
            double width;
            if (dataset.getStartX(i3, 0).doubleValue() < minBin) {
                minBinStart = dataset.getStartX(i3, 0).doubleValue();
            }
            if (!((width = dataset.getEndX(i3, 0).doubleValue() - dataset.getStartX(i3, 0).doubleValue()) < minBin)) continue;
            minBin = width;
        }
        double ticks = -1.0;
        if (!this.YTickMarkTextField.getText().equals("")) {
            try {
                ticks = Double.parseDouble(this.YTickMarkTextField.getText());
                if (ticks <= 0.0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                this.app.showErrorDialog("Enter a valid number for the y-axis tick mark units.");
                return;
            }
        }
        text = text + "<br>Number of bins = " + bins;
        this.app.addLogParagraph("histogram", text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        StatcatoChartFrame frame = new StatcatoChartFrame(this.TitleTextField.getText(), GraphFactory.createHistogram(this.TitleTextField.getText(), this.XTextField.getText(), this.YTextField.getText(), dataset, this.LegendCheckBox.isSelected(), units, minBin, minBinStart, this.CenterRadioButton.isSelected(), ticks), this.app);
        frame.pack();
        frame.setVisible(true);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void GroupByComboBoxItemStateChanged(ItemEvent evt) {
        if (this.GroupByComboBox.getSelectedItem() != null) {
            if (this.GroupByComboBox.getSelectedItem().toString().equals("")) {
                this.LegendCheckBox.setSelected(false);
            } else {
                this.LegendCheckBox.setSelected(true);
            }
        }
    }

    private void X1RadioButtonStateChanged(ChangeEvent evt) {
        if (this.X1RadioButton.isSelected()) {
            this.NumBinsTextField.setEnabled(true);
            this.MinTextField.setEnabled(true);
            this.MaxTextField.setEnabled(true);
        } else {
            this.NumBinsTextField.setEnabled(false);
            this.MinTextField.setEnabled(false);
            this.MaxTextField.setEnabled(false);
        }
    }

    private void X2RadioButtonStateChanged(ChangeEvent evt) {
        if (this.X2RadioButton.isSelected()) {
            this.ClassWidthTextField.setEnabled(true);
            this.Min2TextField.setEnabled(true);
        } else {
            this.ClassWidthTextField.setEnabled(false);
            this.Min2TextField.setEnabled(false);
        }
    }
}

