/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.graph;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.graph.GraphFactory;
import org.statcato.graph.StatcatoChartFrame;
import org.statcato.spreadsheet.Cell;
import org.statcato.utils.HelperFunctions;

public class BarChartDialog
extends StatcatoDialog {
    private JButton AddButton;
    private JButton CancelButton;
    private JComboBox CatComboBox;
    private JRadioButton HorizontalRadioButton;
    private JCheckBox LegendCheckBox;
    private JButton OKButton;
    private JButton RemoveButton;
    private JList SeriesList;
    private JTextField TitleTextField;
    private JRadioButton VerticalRadioButton;
    private JComboBox XComboBox;
    private JTextField XTextField;
    private JTextField YTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;

    public BarChartDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.app = app;
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.initComponents();
        this.customInitComponents();
        this.setHelpFile("graph-barchart");
        this.name = "Bar Chart";
        this.description = "For creating horizontal or vertical bar charts that represent the frequences of a number of data series with data in a number of categories.";
        this.helpStrings.add("To add a data series, select the column containing the data values and click the Add Series button.");
        this.helpStrings.add("Select the column containing category labels for the data values in each series.");
        this.helpStrings.add("Select whether to have horizontal or vertical bars under Directions of bars drop-down menu.");
        this.helpStrings.add("Enter labels for the x and y axis and the plot title in the corresponding text fields.");
        this.helpStrings.add("Select the Show Legend check box to show a legend indicating the different groups.");
        this.pack();
    }

    @Override
    public void updateElements() {
        this.updateComboBox(this.XComboBox);
        this.updateComboBox(this.CatComboBox);
        this.clearMutableColumnsList(this.SeriesList);
    }

    private void customInitComponents() {
        this.ParentSpreadsheet.populateComboBox(this.XComboBox);
        this.ParentSpreadsheet.populateComboBox(this.CatComboBox);
        this.SeriesList.setSelectionMode(0);
        ButtonGroup group = new ButtonGroup();
        group.add(this.HorizontalRadioButton);
        group.add(this.VerticalRadioButton);
        this.getRootPane().setDefaultButton(this.OKButton);
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.CatComboBox = new JComboBox();
        this.XComboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jLabel1 = new JLabel();
        this.AddButton = new JButton();
        this.jLabel8 = new JLabel();
        this.RemoveButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.SeriesList = new JList(new DefaultListModel());
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jPanel2 = new JPanel();
        this.VerticalRadioButton = new JRadioButton();
        this.HorizontalRadioButton = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.jLabel7 = new JLabel();
        this.YTextField = new JTextField();
        this.LegendCheckBox = new JCheckBox();
        this.XTextField = new JTextField();
        this.TitleTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel5 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Bar Chart");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BarChartDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BarChartDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Graph Variables"));
        this.XComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BarChartDialog.this.XComboBoxItemStateChanged(evt);
            }
        });
        this.jLabel4.setText("Select the column variable containing categories:");
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Graph Series");
        this.AddButton.setText("Add Series");
        this.AddButton.setEnabled(false);
        this.AddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BarChartDialog.this.AddButtonActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Select the series to be removed:");
        this.RemoveButton.setText("Remove Series");
        this.RemoveButton.setEnabled(false);
        this.RemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BarChartDialog.this.RemoveButtonActionPerformed(evt);
            }
        });
        this.SeriesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                BarChartDialog.this.SeriesListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.SeriesList);
        this.jLabel2.setText("Select the column variable of a new series:");
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Categories");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 103, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.XComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.AddButton)).addComponent(this.jLabel2).addComponent(this.jLabel8).addComponent(this.RemoveButton))).addComponent(this.jLabel3).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.CatComboBox, -2, 110, -2).addComponent(this.jLabel4))))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.XComboBox, -2, -1, -2).addComponent(this.AddButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.RemoveButton)).addComponent(this.jScrollPane1, -2, -1, -2)).addGap(26, 26, 26).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CatComboBox, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Direction of Bars"));
        this.VerticalRadioButton.setSelected(true);
        this.VerticalRadioButton.setText("Vertical");
        this.HorizontalRadioButton.setText("Horizontal");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.HorizontalRadioButton).addComponent(this.VerticalRadioButton)).addContainerGap(257, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.HorizontalRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.VerticalRadioButton).addGap(47, 47, 47)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Graph Options"));
        this.jLabel7.setText("X-axis Label:");
        this.LegendCheckBox.setSelected(true);
        this.LegendCheckBox.setText("Show Legend");
        this.TitleTextField.setText("Bar Chart");
        this.jLabel6.setText("Plot Title:");
        this.jLabel5.setText("Y-axis Label:");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.XTextField, -2, 251, -2).addComponent(this.YTextField, -2, 251, -2).addComponent(this.TitleTextField, -2, 232, -2))).addComponent(this.jLabel7).addComponent(this.LegendCheckBox)).addContainerGap()));
        jPanel3Layout.linkSize(0, this.TitleTextField, this.XTextField, this.YTextField);
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.XTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.YTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.TitleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 19, Short.MAX_VALUE).addComponent(this.LegendCheckBox)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(285, 285, 285).addComponent(this.OKButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap()));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGap(26, 26, 26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OKButton).addComponent(this.CancelButton)).addGap(22, 22, 22)));
        this.pack();
    }

    private void SeriesListValueChanged(ListSelectionEvent evt) {
        if (this.SeriesList.getSelectedIndex() != -1) {
            this.RemoveButton.setEnabled(true);
        } else {
            this.RemoveButton.setEnabled(false);
        }
    }

    private void RemoveButtonActionPerformed(ActionEvent evt) {
        if (this.SeriesList.getSelectedValue() != null) {
            ((DefaultListModel)this.SeriesList.getModel()).removeElementAt(this.SeriesList.getSelectedIndex());
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.app.compoundEdit = new DialogEdit("bar chart");
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        String text = "";
        if (this.CatComboBox.getSelectedIndex() == 0) {
            this.app.showErrorDialog("Select the column containing the categories.");
            return;
        }
        if (this.SeriesList.getModel().getSize() == 0) {
            this.app.showErrorDialog("Select at least one graph variable.");
            return;
        }
        int catColumn = this.ParentSpreadsheet.parseColumnNumber((String)this.CatComboBox.getSelectedItem());
        text = text + "Categories in " + this.CatComboBox.getSelectedItem() + "<br>";
        Vector<Cell> CatColumnVector = this.ParentSpreadsheet.getColumn(catColumn);
        CatColumnVector = HelperFunctions.removeNullCells(CatColumnVector);
        text = text + "Graph variables: ";
        for (int i = 0; i < this.SeriesList.getModel().getSize(); ++i) {
            String x = (String)this.SeriesList.getModel().getElementAt(i);
            text = text + x + " ";
            int selectedXColumn = this.ParentSpreadsheet.parseColumnNumber(x);
            Vector<Cell> StrColumnVector = this.ParentSpreadsheet.getColumn(selectedXColumn);
            Vector<Double> XColumnVector = HelperFunctions.ConvertInputVectorToDoubles(StrColumnVector);
            if (XColumnVector == null) {
                this.app.showErrorDialog("Invalid input column " + x + ": all data must be numbers.");
                return;
            }
            if ((XColumnVector = HelperFunctions.removeNullValues(XColumnVector)).size() != CatColumnVector.size()) {
                this.app.showErrorDialog("The number of values must be the same as the number of categories.");
                return;
            }
            for (int j = 0; j < XColumnVector.size(); ++j) {
                dataset.addValue(XColumnVector.elementAt(j), (Comparable)((Object)x), (Comparable)((Object)CatColumnVector.elementAt(j).getContents()));
            }
        }
        PlotOrientation orientation = this.HorizontalRadioButton.isSelected() ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
        this.app.addLogParagraph("Bar Chart", text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        StatcatoChartFrame frame = new StatcatoChartFrame(this.TitleTextField.getText(), GraphFactory.createBarChart(this.TitleTextField.getText(), this.XTextField.getText(), this.YTextField.getText(), dataset, orientation, this.LegendCheckBox.isSelected()), this.app);
        frame.pack();
        frame.setVisible(true);
        this.setVisible(false);
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void XComboBoxItemStateChanged(ItemEvent evt) {
        if (this.XComboBox.getSelectedIndex() == 0) {
            this.AddButton.setEnabled(false);
        } else {
            this.AddButton.setEnabled(true);
        }
    }

    private void AddButtonActionPerformed(ActionEvent evt) {
        if (this.XComboBox.getSelectedIndex() == 0) {
            this.app.showErrorDialog("Select the column variable of the new series.");
            return;
        }
        String x = this.XComboBox.getSelectedItem().toString();
        ((DefaultListModel)this.SeriesList.getModel()).addElement(x);
    }
}

