/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.calculator;

import java.util.Vector;
import org.statcato.calculator.CompUnit;
import org.statcato.calculator.MathFunction;
import org.statcato.statistics.SpecialFunctions;

public class MathOperations {
    public static Vector<Double> add(Vector<Double> v1, Vector<Double> v2) {
        if (v1.size() > v2.size()) {
            Vector temp = (Vector)v1.clone();
            v1 = (Vector)v2.clone();
            v2 = temp;
        }
        Vector<Double> v = new Vector<Double>();
        for (int i = 0; i < v1.size(); ++i) {
            double n1 = 0.0;
            double n2 = 0.0;
            if (v1.elementAt(i) == null && v2.elementAt(i) == null) {
                v.addElement(null);
                continue;
            }
            if (v1.elementAt(i) != null) {
                n1 = (Double)v1.elementAt(i);
            }
            if (v2.elementAt(i) != null) {
                n2 = (Double)v2.elementAt(i);
            }
            v.addElement(new Double(n1 + n2));
        }
        for (int j = i; j < v2.size(); ++j) {
            v.addElement((Double)v2.elementAt(j));
        }
        return v;
    }

    public static CompUnit add(CompUnit c1, CompUnit c2) {
        int type1 = c1.getType();
        int type2 = c2.getType();
        if (type1 == 8 && type2 == 8) {
            return new CompUnit(8, c1.getNumber() + c2.getNumber());
        }
        if (type1 == 10 && type2 == 10) {
            return new CompUnit(10, MathOperations.add(c1.getColumn(), c2.getColumn()));
        }
        Vector<Double> v1 = null;
        Vector<Double> v2 = null;
        if (type1 == 8) {
            v2 = c2.getColumn();
            v1 = new Vector();
            double value = c1.getNumber();
            for (int i = 0; i < v2.size(); ++i) {
                v1.add(new Double(value));
            }
        } else {
            v1 = c1.getColumn();
            v2 = new Vector();
            double value = c2.getNumber();
            for (int i = 0; i < v1.size(); ++i) {
                v2.add(new Double(value));
            }
        }
        return new CompUnit(10, MathOperations.add(v1, v2));
    }

    public static CompUnit negate(CompUnit c) {
        int type = c.getType();
        if (type == 8) {
            return new CompUnit(8, -1.0 * c.getNumber());
        }
        if (type == 10) {
            Vector<Double> v1 = c.getColumn();
            Vector<Double> v2 = new Vector<Double>();
            for (int i = 0; i < v1.size(); ++i) {
                if (v1.elementAt(i) == null) {
                    v2.addElement(null);
                    continue;
                }
                double n = -1.0 * v1.elementAt(i);
                v2.addElement(new Double(n));
            }
            return new CompUnit(10, v2);
        }
        return null;
    }

    public static Vector<Double> multiply(Vector<Double> v1, Vector<Double> v2) {
        if (v1.size() > v2.size()) {
            Vector temp = (Vector)v1.clone();
            v1 = (Vector)v2.clone();
            v2 = temp;
        }
        Vector<Double> v = new Vector<Double>();
        for (int i = 0; i < v1.size(); ++i) {
            double n1 = 0.0;
            double n2 = 0.0;
            if (v1.elementAt(i) == null || v2.elementAt(i) == null) {
                v.addElement(null);
                continue;
            }
            n1 = (Double)v1.elementAt(i);
            n2 = (Double)v2.elementAt(i);
            v.addElement(new Double(n1 * n2));
        }
        return v;
    }

    public static CompUnit subtract(CompUnit c1, CompUnit c2) {
        CompUnit nc2 = MathOperations.negate(c2);
        return MathOperations.add(c1, nc2);
    }

    public static CompUnit multiply(CompUnit c1, CompUnit c2) {
        int type1 = c1.getType();
        int type2 = c2.getType();
        if (type1 == 8 && type2 == 8) {
            return new CompUnit(8, c1.getNumber() * c2.getNumber());
        }
        if (type1 == 10 && type2 == 10) {
            return new CompUnit(10, MathOperations.multiply(c1.getColumn(), c2.getColumn()));
        }
        Vector<Double> v1 = null;
        Vector<Double> v2 = null;
        if (type1 == 8) {
            v2 = c2.getColumn();
            v1 = new Vector();
            double value = c1.getNumber();
            for (int i = 0; i < v2.size(); ++i) {
                v1.add(new Double(value));
            }
        } else {
            v1 = c1.getColumn();
            v2 = new Vector();
            double value = c2.getNumber();
            for (int i = 0; i < v1.size(); ++i) {
                v2.add(new Double(value));
            }
        }
        return new CompUnit(10, MathOperations.multiply(v1, v2));
    }

    public static CompUnit reciprocal(CompUnit c) {
        int type = c.getType();
        if (type == 8) {
            return new CompUnit(8, 1.0 / c.getNumber());
        }
        Vector<Double> v = c.getColumn();
        for (int i = 0; i < v.size(); ++i) {
            Double value = v.elementAt(i);
            if (value == null) {
                v.setElementAt(null, i);
                continue;
            }
            v.setElementAt(new Double(1.0 / value), i);
        }
        return new CompUnit(10, v);
    }

    public static CompUnit divide(CompUnit c1, CompUnit c2) {
        return MathOperations.multiply(c1, MathOperations.reciprocal(c2));
    }

    public static CompUnit power(CompUnit c1, CompUnit c2) {
        int type1 = c1.getType();
        int type2 = c2.getType();
        if (type1 == 8 && type2 == 8) {
            return new CompUnit(8, Math.pow(c1.getNumber(), c2.getNumber()));
        }
        if (type1 == 10 && type2 == 10) {
            return new CompUnit(10, MathOperations.power(c1.getColumn(), c2.getColumn()));
        }
        Vector<Double> v1 = null;
        Vector<Double> v2 = null;
        if (type1 == 8) {
            v2 = c2.getColumn();
            v1 = new Vector();
            double value = c1.getNumber();
            for (int i = 0; i < v2.size(); ++i) {
                v1.add(new Double(value));
            }
        } else {
            v1 = c1.getColumn();
            v2 = new Vector();
            double value = c2.getNumber();
            for (int i = 0; i < v1.size(); ++i) {
                v2.add(new Double(value));
            }
        }
        return new CompUnit(10, MathOperations.power(v1, v2));
    }

    public static Vector<Double> power(Vector<Double> v1, Vector<Double> v2) {
        Vector<Double> v = new Vector<Double>();
        for (int i = 0; i < v1.size() && i < v2.size(); ++i) {
            double n1 = 0.0;
            double n2 = 0.0;
            if (v1.elementAt(i) == null || v2.elementAt(i) == null) {
                v.addElement(null);
                continue;
            }
            n1 = v1.elementAt(i);
            n2 = v2.elementAt(i);
            v.addElement(new Double(Math.pow(n1, n2)));
        }
        return v;
    }

    public static CompUnit functionCall(CompUnit c, MathFunction f) {
        return f.call(c);
    }

    public static double factorial(double x) {
        return SpecialFunctions.factrl((int)x);
    }
}

